/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.Host;
import software.amazon.awssdk.services.batch.transform.VolumeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Volume
implements StructuredPojo,
ToCopyableBuilder<Builder, Volume> {
    private final Host host;
    private final String name;

    private Volume(BuilderImpl builder) {
        this.host = builder.host;
        this.name = builder.name;
    }

    public Host host() {
        return this.host;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.host() == null ? 0 : this.host().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        if (other.host() == null ^ this.host() == null) {
            return false;
        }
        if (other.host() != null && !other.host().equals(this.host())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        return other.name() == null || other.name().equals(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.host() != null) {
            sb.append("Host: ").append(this.host()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "host": {
                return Optional.of(clazz.cast(this.host()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VolumeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Host host;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            this.host(model.host);
            this.name(model.name);
        }

        public final Host.Builder getHost() {
            return this.host != null ? this.host.toBuilder() : null;
        }

        @Override
        public final Builder host(Host host) {
            this.host = host;
            return this;
        }

        public final void setHost(Host.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public Volume build() {
            return new Volume(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Volume> {
        public Builder host(Host var1);

        public Builder name(String var1);
    }
}

