/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.batch.model.KeyValuePair;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.transform.ContainerOverridesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ContainerOverrides
implements StructuredPojo,
ToCopyableBuilder<Builder, ContainerOverrides> {
    private final Integer vcpus;
    private final Integer memory;
    private final List<String> command;
    private final List<KeyValuePair> environment;

    private ContainerOverrides(BuilderImpl builder) {
        this.vcpus = builder.vcpus;
        this.memory = builder.memory;
        this.command = builder.command;
        this.environment = builder.environment;
    }

    public Integer vcpus() {
        return this.vcpus;
    }

    public Integer memory() {
        return this.memory;
    }

    public List<String> command() {
        return this.command;
    }

    public List<KeyValuePair> environment() {
        return this.environment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.vcpus() == null ? 0 : this.vcpus().hashCode());
        hashCode = 31 * hashCode + (this.memory() == null ? 0 : this.memory().hashCode());
        hashCode = 31 * hashCode + (this.command() == null ? 0 : this.command().hashCode());
        hashCode = 31 * hashCode + (this.environment() == null ? 0 : this.environment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerOverrides)) {
            return false;
        }
        ContainerOverrides other = (ContainerOverrides)obj;
        if (other.vcpus() == null ^ this.vcpus() == null) {
            return false;
        }
        if (other.vcpus() != null && !other.vcpus().equals(this.vcpus())) {
            return false;
        }
        if (other.memory() == null ^ this.memory() == null) {
            return false;
        }
        if (other.memory() != null && !other.memory().equals(this.memory())) {
            return false;
        }
        if (other.command() == null ^ this.command() == null) {
            return false;
        }
        if (other.command() != null && !other.command().equals(this.command())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        return other.environment() == null || other.environment().equals(this.environment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vcpus() != null) {
            sb.append("Vcpus: ").append(this.vcpus()).append(",");
        }
        if (this.memory() != null) {
            sb.append("Memory: ").append(this.memory()).append(",");
        }
        if (this.command() != null) {
            sb.append("Command: ").append(this.command()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vcpus": {
                return Optional.of(clazz.cast(this.vcpus()));
            }
            case "memory": {
                return Optional.of(clazz.cast(this.memory()));
            }
            case "command": {
                return Optional.of(clazz.cast(this.command()));
            }
            case "environment": {
                return Optional.of(clazz.cast(this.environment()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerOverridesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer vcpus;
        private Integer memory;
        private List<String> command;
        private List<KeyValuePair> environment;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerOverrides model) {
            this.vcpus(model.vcpus);
            this.memory(model.memory);
            this.command(model.command);
            this.environment(model.environment);
        }

        public final Integer getVcpus() {
            return this.vcpus;
        }

        @Override
        public final Builder vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        public final void setVcpus(Integer vcpus) {
            this.vcpus = vcpus;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        public final Collection<String> getCommand() {
            return this.command;
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        public final Collection<KeyValuePair.Builder> getEnvironment() {
            return this.environment != null ? (Collection)this.environment.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        public ContainerOverrides build() {
            return new ContainerOverrides(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContainerOverrides> {
        public Builder vcpus(Integer var1);

        public Builder memory(Integer var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder environment(Collection<KeyValuePair> var1);

        public Builder environment(KeyValuePair ... var1);
    }
}

