/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.AttemptContainerDetail;
import software.amazon.awssdk.services.batch.transform.AttemptDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttemptDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, AttemptDetail> {
    private final AttemptContainerDetail container;
    private final Long startedAt;
    private final Long stoppedAt;
    private final String statusReason;

    private AttemptDetail(BuilderImpl builder) {
        this.container = builder.container;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.statusReason = builder.statusReason;
    }

    public AttemptContainerDetail container() {
        return this.container;
    }

    public Long startedAt() {
        return this.startedAt;
    }

    public Long stoppedAt() {
        return this.stoppedAt;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.container() == null ? 0 : this.container().hashCode());
        hashCode = 31 * hashCode + (this.startedAt() == null ? 0 : this.startedAt().hashCode());
        hashCode = 31 * hashCode + (this.stoppedAt() == null ? 0 : this.stoppedAt().hashCode());
        hashCode = 31 * hashCode + (this.statusReason() == null ? 0 : this.statusReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptDetail)) {
            return false;
        }
        AttemptDetail other = (AttemptDetail)obj;
        if (other.container() == null ^ this.container() == null) {
            return false;
        }
        if (other.container() != null && !other.container().equals(this.container())) {
            return false;
        }
        if (other.startedAt() == null ^ this.startedAt() == null) {
            return false;
        }
        if (other.startedAt() != null && !other.startedAt().equals(this.startedAt())) {
            return false;
        }
        if (other.stoppedAt() == null ^ this.stoppedAt() == null) {
            return false;
        }
        if (other.stoppedAt() != null && !other.stoppedAt().equals(this.stoppedAt())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        return other.statusReason() == null || other.statusReason().equals(this.statusReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.container() != null) {
            sb.append("Container: ").append(this.container()).append(",");
        }
        if (this.startedAt() != null) {
            sb.append("StartedAt: ").append(this.startedAt()).append(",");
        }
        if (this.stoppedAt() != null) {
            sb.append("StoppedAt: ").append(this.stoppedAt()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "container": {
                return Optional.of(clazz.cast(this.container()));
            }
            case "startedAt": {
                return Optional.of(clazz.cast(this.startedAt()));
            }
            case "stoppedAt": {
                return Optional.of(clazz.cast(this.stoppedAt()));
            }
            case "statusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttemptDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AttemptContainerDetail container;
        private Long startedAt;
        private Long stoppedAt;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptDetail model) {
            this.container(model.container);
            this.startedAt(model.startedAt);
            this.stoppedAt(model.stoppedAt);
            this.statusReason(model.statusReason);
        }

        public final AttemptContainerDetail.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        @Override
        public final Builder container(AttemptContainerDetail container) {
            this.container = container;
            return this;
        }

        public final void setContainer(AttemptContainerDetail.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public AttemptDetail build() {
            return new AttemptDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttemptDetail> {
        public Builder container(AttemptContainerDetail var1);

        public Builder startedAt(Long var1);

        public Builder stoppedAt(Long var1);

        public Builder statusReason(String var1);
    }
}

