/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.MountPointMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MountPoint
implements StructuredPojo,
ToCopyableBuilder<Builder, MountPoint> {
    private final String containerPath;
    private final Boolean readOnly;
    private final String sourceVolume;

    private MountPoint(BuilderImpl builder) {
        this.containerPath = builder.containerPath;
        this.readOnly = builder.readOnly;
        this.sourceVolume = builder.sourceVolume;
    }

    public String containerPath() {
        return this.containerPath;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public String sourceVolume() {
        return this.sourceVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.containerPath() == null ? 0 : this.containerPath().hashCode());
        hashCode = 31 * hashCode + (this.readOnly() == null ? 0 : this.readOnly().hashCode());
        hashCode = 31 * hashCode + (this.sourceVolume() == null ? 0 : this.sourceVolume().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountPoint)) {
            return false;
        }
        MountPoint other = (MountPoint)obj;
        if (other.containerPath() == null ^ this.containerPath() == null) {
            return false;
        }
        if (other.containerPath() != null && !other.containerPath().equals(this.containerPath())) {
            return false;
        }
        if (other.readOnly() == null ^ this.readOnly() == null) {
            return false;
        }
        if (other.readOnly() != null && !other.readOnly().equals(this.readOnly())) {
            return false;
        }
        if (other.sourceVolume() == null ^ this.sourceVolume() == null) {
            return false;
        }
        return other.sourceVolume() == null || other.sourceVolume().equals(this.sourceVolume());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerPath() != null) {
            sb.append("ContainerPath: ").append(this.containerPath()).append(",");
        }
        if (this.readOnly() != null) {
            sb.append("ReadOnly: ").append(this.readOnly()).append(",");
        }
        if (this.sourceVolume() != null) {
            sb.append("SourceVolume: ").append(this.sourceVolume()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MountPointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String containerPath;
        private Boolean readOnly;
        private String sourceVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(MountPoint model) {
            this.setContainerPath(model.containerPath);
            this.setReadOnly(model.readOnly);
            this.setSourceVolume(model.sourceVolume);
        }

        public final String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public final String getSourceVolume() {
            return this.sourceVolume;
        }

        @Override
        public final Builder sourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        public final void setSourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
        }

        public MountPoint build() {
            return new MountPoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MountPoint> {
        public Builder containerPath(String var1);

        public Builder readOnly(Boolean var1);

        public Builder sourceVolume(String var1);
    }
}

