/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeJobsRequest> {
    private final List<String> jobs;

    private DescribeJobsRequest(BuilderImpl builder) {
        this.jobs = builder.jobs;
    }

    public List<String> jobs() {
        return this.jobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobs() == null ? 0 : this.jobs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsRequest)) {
            return false;
        }
        DescribeJobsRequest other = (DescribeJobsRequest)((Object)obj);
        if (other.jobs() == null ^ this.jobs() == null) {
            return false;
        }
        return other.jobs() == null || other.jobs().equals(this.jobs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobs() != null) {
            sb.append("Jobs: ").append(this.jobs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> jobs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsRequest model) {
            this.setJobs(model.jobs);
        }

        public final Collection<String> getJobs() {
            return this.jobs;
        }

        @Override
        public final Builder jobs(Collection<String> jobs) {
            this.jobs = StringListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(String ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        public final void setJobs(Collection<String> jobs) {
            this.jobs = StringListCopier.copy(jobs);
        }

        @SafeVarargs
        public final void setJobs(String ... jobs) {
            this.jobs(Arrays.asList(jobs));
        }

        public DescribeJobsRequest build() {
            return new DescribeJobsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobsRequest> {
        public Builder jobs(Collection<String> var1);

        public Builder jobs(String ... var1);
    }
}

