/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ComputeEnvironmentOrderMarshaller {
    private static final MarshallingInfo<Integer> ORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("order").isBinary(false).build();
    private static final MarshallingInfo<String> COMPUTEENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computeEnvironment").isBinary(false).build();
    private static final ComputeEnvironmentOrderMarshaller INSTANCE = new ComputeEnvironmentOrderMarshaller();

    private ComputeEnvironmentOrderMarshaller() {
    }

    public static ComputeEnvironmentOrderMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComputeEnvironmentOrder computeEnvironmentOrder, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)computeEnvironmentOrder, (String)"computeEnvironmentOrder");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)computeEnvironmentOrder.order(), ORDER_BINDING);
            protocolMarshaller.marshall((Object)computeEnvironmentOrder.computeEnvironment(), COMPUTEENVIRONMENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

