/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.ContainerProperties;
import software.amazon.awssdk.services.batch.model.JobTimeout;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.services.batch.transform.JobDefinitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, JobDefinition> {
    private final String jobDefinitionName;
    private final String jobDefinitionArn;
    private final Integer revision;
    private final String status;
    private final String type;
    private final Map<String, String> parameters;
    private final RetryStrategy retryStrategy;
    private final ContainerProperties containerProperties;
    private final JobTimeout timeout;

    private JobDefinition(BuilderImpl builder) {
        this.jobDefinitionName = builder.jobDefinitionName;
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.revision = builder.revision;
        this.status = builder.status;
        this.type = builder.type;
        this.parameters = builder.parameters;
        this.retryStrategy = builder.retryStrategy;
        this.containerProperties = builder.containerProperties;
        this.timeout = builder.timeout;
    }

    public String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public String jobDefinitionArn() {
        return this.jobDefinitionArn;
    }

    public Integer revision() {
        return this.revision;
    }

    public String status() {
        return this.status;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public ContainerProperties containerProperties() {
        return this.containerProperties;
    }

    public JobTimeout timeout() {
        return this.timeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDefinition)) {
            return false;
        }
        JobDefinition other = (JobDefinition)obj;
        return Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.jobDefinitionArn(), other.jobDefinitionArn()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.retryStrategy(), other.retryStrategy()) && Objects.equals(this.containerProperties(), other.containerProperties()) && Objects.equals(this.timeout(), other.timeout());
    }

    public String toString() {
        return ToString.builder((String)"JobDefinition").add("JobDefinitionName", (Object)this.jobDefinitionName()).add("JobDefinitionArn", (Object)this.jobDefinitionArn()).add("Revision", (Object)this.revision()).add("Status", (Object)this.status()).add("Type", (Object)this.type()).add("Parameters", this.parameters()).add("RetryStrategy", (Object)this.retryStrategy()).add("ContainerProperties", (Object)this.containerProperties()).add("Timeout", (Object)this.timeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionName()));
            }
            case "jobDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionArn()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "retryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
            case "containerProperties": {
                return Optional.ofNullable(clazz.cast(this.containerProperties()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private String jobDefinitionArn;
        private Integer revision;
        private String status;
        private String type;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private RetryStrategy retryStrategy;
        private ContainerProperties containerProperties;
        private JobTimeout timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDefinition model) {
            this.jobDefinitionName(model.jobDefinitionName);
            this.jobDefinitionArn(model.jobDefinitionArn);
            this.revision(model.revision);
            this.status(model.status);
            this.type(model.type);
            this.parameters(model.parameters);
            this.retryStrategy(model.retryStrategy);
            this.containerProperties(model.containerProperties);
            this.timeout(model.timeout);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getJobDefinitionArn() {
            return this.jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        public final ContainerProperties.Builder getContainerProperties() {
            return this.containerProperties != null ? this.containerProperties.toBuilder() : null;
        }

        @Override
        public final Builder containerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        public final void setContainerProperties(ContainerProperties.BuilderImpl containerProperties) {
            this.containerProperties = containerProperties != null ? containerProperties.build() : null;
        }

        public final JobTimeout.Builder getTimeout() {
            return this.timeout != null ? this.timeout.toBuilder() : null;
        }

        @Override
        public final Builder timeout(JobTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(JobTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        public JobDefinition build() {
            return new JobDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobDefinition> {
        public Builder jobDefinitionName(String var1);

        public Builder jobDefinitionArn(String var1);

        public Builder revision(Integer var1);

        public Builder status(String var1);

        public Builder type(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((RetryStrategy)((RetryStrategy.Builder)RetryStrategy.builder().applyMutation(retryStrategy)).build());
        }

        public Builder containerProperties(ContainerProperties var1);

        default public Builder containerProperties(Consumer<ContainerProperties.Builder> containerProperties) {
            return this.containerProperties((ContainerProperties)((ContainerProperties.Builder)ContainerProperties.builder().applyMutation(containerProperties)).build());
        }

        public Builder timeout(JobTimeout var1);

        default public Builder timeout(Consumer<JobTimeout.Builder> timeout) {
            return this.timeout((JobTimeout)((JobTimeout.Builder)JobTimeout.builder().applyMutation(timeout)).build());
        }
    }
}

