/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.AttemptContainerDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttemptContainerDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, AttemptContainerDetail> {
    private final String containerInstanceArn;
    private final String taskArn;
    private final Integer exitCode;
    private final String reason;
    private final String logStreamName;

    private AttemptContainerDetail(BuilderImpl builder) {
        this.containerInstanceArn = builder.containerInstanceArn;
        this.taskArn = builder.taskArn;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
        this.logStreamName = builder.logStreamName;
    }

    public String containerInstanceArn() {
        return this.containerInstanceArn;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public String reason() {
        return this.reason;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptContainerDetail)) {
            return false;
        }
        AttemptContainerDetail other = (AttemptContainerDetail)obj;
        return Objects.equals(this.containerInstanceArn(), other.containerInstanceArn()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.exitCode(), other.exitCode()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.logStreamName(), other.logStreamName());
    }

    public String toString() {
        return ToString.builder((String)"AttemptContainerDetail").add("ContainerInstanceArn", (Object)this.containerInstanceArn()).add("TaskArn", (Object)this.taskArn()).add("ExitCode", (Object)this.exitCode()).add("Reason", (Object)this.reason()).add("LogStreamName", (Object)this.logStreamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.containerInstanceArn()));
            }
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "exitCode": {
                return Optional.ofNullable(clazz.cast(this.exitCode()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttemptContainerDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerInstanceArn;
        private String taskArn;
        private Integer exitCode;
        private String reason;
        private String logStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptContainerDetail model) {
            this.containerInstanceArn(model.containerInstanceArn);
            this.taskArn(model.taskArn);
            this.exitCode(model.exitCode);
            this.reason(model.reason);
            this.logStreamName(model.logStreamName);
        }

        public final String getContainerInstanceArn() {
            return this.containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final Integer getExitCode() {
            return this.exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public AttemptContainerDetail build() {
            return new AttemptContainerDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttemptContainerDetail> {
        public Builder containerInstanceArn(String var1);

        public Builder taskArn(String var1);

        public Builder exitCode(Integer var1);

        public Builder reason(String var1);

        public Builder logStreamName(String var1);
    }
}

