/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.AttemptDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttemptDetailMarshaller {
    private static final MarshallingInfo<StructuredPojo> CONTAINER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("container").isBinary(false).build();
    private static final MarshallingInfo<Long> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedAt").isBinary(false).build();
    private static final MarshallingInfo<Long> STOPPEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stoppedAt").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusReason").isBinary(false).build();
    private static final AttemptDetailMarshaller INSTANCE = new AttemptDetailMarshaller();

    private AttemptDetailMarshaller() {
    }

    public static AttemptDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttemptDetail attemptDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)attemptDetail, (String)"attemptDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attemptDetail.container(), CONTAINER_BINDING);
            protocolMarshaller.marshall((Object)attemptDetail.startedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)attemptDetail.stoppedAt(), STOPPEDAT_BINDING);
            protocolMarshaller.marshall((Object)attemptDetail.statusReason(), STATUSREASON_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

