/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ContainerProperties;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ContainerPropertiesMarshaller {
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("image").isBinary(false).build();
    private static final MarshallingInfo<Integer> VCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vcpus").isBinary(false).build();
    private static final MarshallingInfo<Integer> MEMORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").isBinary(false).build();
    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("command").isBinary(false).build();
    private static final MarshallingInfo<String> JOBROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobRoleArn").isBinary(false).build();
    private static final MarshallingInfo<List> VOLUMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("volumes").isBinary(false).build();
    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").isBinary(false).build();
    private static final MarshallingInfo<List> MOUNTPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mountPoints").isBinary(false).build();
    private static final MarshallingInfo<Boolean> READONLYROOTFILESYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readonlyRootFilesystem").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PRIVILEGED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privileged").isBinary(false).build();
    private static final MarshallingInfo<List> ULIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ulimits").isBinary(false).build();
    private static final MarshallingInfo<String> USER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("user").isBinary(false).build();
    private static final ContainerPropertiesMarshaller INSTANCE = new ContainerPropertiesMarshaller();

    private ContainerPropertiesMarshaller() {
    }

    public static ContainerPropertiesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ContainerProperties containerProperties, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)containerProperties, (String)"containerProperties");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)containerProperties.image(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.vcpus(), VCPUS_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.memory(), MEMORY_BINDING);
            protocolMarshaller.marshall(containerProperties.command(), COMMAND_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.jobRoleArn(), JOBROLEARN_BINDING);
            protocolMarshaller.marshall(containerProperties.volumes(), VOLUMES_BINDING);
            protocolMarshaller.marshall(containerProperties.environment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall(containerProperties.mountPoints(), MOUNTPOINTS_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.readonlyRootFilesystem(), READONLYROOTFILESYSTEM_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.privileged(), PRIVILEGED_BINDING);
            protocolMarshaller.marshall(containerProperties.ulimits(), ULIMITS_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.user(), USER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

