/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.CEState;
import software.amazon.awssdk.services.batch.model.ComputeResourceUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateComputeEnvironmentRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, UpdateComputeEnvironmentRequest> {
    private final String computeEnvironment;
    private final String state;
    private final ComputeResourceUpdate computeResources;
    private final String serviceRole;

    private UpdateComputeEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.computeEnvironment = builder.computeEnvironment;
        this.state = builder.state;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    public String computeEnvironment() {
        return this.computeEnvironment;
    }

    public CEState state() {
        return CEState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public ComputeResourceUpdate computeResources() {
        return this.computeResources;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeEnvironmentRequest)) {
            return false;
        }
        UpdateComputeEnvironmentRequest other = (UpdateComputeEnvironmentRequest)((Object)obj);
        return Objects.equals(this.computeEnvironment(), other.computeEnvironment()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.computeResources(), other.computeResources()) && Objects.equals(this.serviceRole(), other.serviceRole());
    }

    public String toString() {
        return ToString.builder((String)"UpdateComputeEnvironmentRequest").add("ComputeEnvironment", (Object)this.computeEnvironment()).add("State", (Object)this.stateAsString()).add("ComputeResources", (Object)this.computeResources()).add("ServiceRole", (Object)this.serviceRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironment": {
                return Optional.of(clazz.cast(this.computeEnvironment()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "computeResources": {
                return Optional.of(clazz.cast(this.computeResources()));
            }
            case "serviceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String computeEnvironment;
        private String state;
        private ComputeResourceUpdate computeResources;
        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeEnvironmentRequest model) {
            super(model);
            this.computeEnvironment(model.computeEnvironment);
            this.state(model.state);
            this.computeResources(model.computeResources);
            this.serviceRole(model.serviceRole);
        }

        public final String getComputeEnvironment() {
            return this.computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ComputeResourceUpdate.Builder getComputeResources() {
            return this.computeResources != null ? this.computeResources.toBuilder() : null;
        }

        @Override
        public final Builder computeResources(ComputeResourceUpdate computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResourceUpdate.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateComputeEnvironmentRequest build() {
            return new UpdateComputeEnvironmentRequest(this);
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    CopyableBuilder<Builder, UpdateComputeEnvironmentRequest> {
        public Builder computeEnvironment(String var1);

        public Builder state(String var1);

        public Builder state(CEState var1);

        public Builder computeResources(ComputeResourceUpdate var1);

        default public Builder computeResources(Consumer<ComputeResourceUpdate.Builder> computeResources) {
            return this.computeResources((ComputeResourceUpdate)((ComputeResourceUpdate.Builder)ComputeResourceUpdate.builder().apply(computeResources)).build());
        }

        public Builder serviceRole(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

