/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobsRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, DescribeJobsRequest> {
    private final List<String> jobs;

    private DescribeJobsRequest(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
    }

    public List<String> jobs() {
        return this.jobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsRequest)) {
            return false;
        }
        DescribeJobsRequest other = (DescribeJobsRequest)((Object)obj);
        return Objects.equals(this.jobs(), other.jobs());
    }

    public String toString() {
        return ToString.builder((String)"DescribeJobsRequest").add("Jobs", this.jobs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobs": {
                return Optional.of(clazz.cast(this.jobs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private List<String> jobs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsRequest model) {
            super(model);
            this.jobs(model.jobs);
        }

        public final Collection<String> getJobs() {
            return this.jobs;
        }

        @Override
        public final Builder jobs(Collection<String> jobs) {
            this.jobs = StringListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(String ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        public final void setJobs(Collection<String> jobs) {
            this.jobs = StringListCopier.copy(jobs);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeJobsRequest build() {
            return new DescribeJobsRequest(this);
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    CopyableBuilder<Builder, DescribeJobsRequest> {
        public Builder jobs(Collection<String> var1);

        public Builder jobs(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

