/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.batch.model.ContainerProperties;
import software.amazon.awssdk.services.batch.transform.KeyValuePairUnmarshaller;
import software.amazon.awssdk.services.batch.transform.MountPointUnmarshaller;
import software.amazon.awssdk.services.batch.transform.UlimitUnmarshaller;
import software.amazon.awssdk.services.batch.transform.VolumeUnmarshaller;

public class ContainerPropertiesUnmarshaller
implements Unmarshaller<ContainerProperties, JsonUnmarshallerContext> {
    private static ContainerPropertiesUnmarshaller INSTANCE;

    public ContainerProperties unmarshall(JsonUnmarshallerContext context) throws Exception {
        ContainerProperties.Builder containerPropertiesBuilder = ContainerProperties.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("image", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.image((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("vcpus", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.vcpus((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("memory", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.memory((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("command", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.command(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("jobRoleArn", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.jobRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("volumes", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.volumes(new ListUnmarshaller((Unmarshaller)VolumeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("environment", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.environment(new ListUnmarshaller((Unmarshaller)KeyValuePairUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("mountPoints", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.mountPoints(new ListUnmarshaller((Unmarshaller)MountPointUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("readonlyRootFilesystem", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.readonlyRootFilesystem((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("privileged", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.privileged((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("ulimits", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.ulimits(new ListUnmarshaller((Unmarshaller)UlimitUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("user", targetDepth)) {
                    context.nextToken();
                    containerPropertiesBuilder.user((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ContainerProperties)containerPropertiesBuilder.build();
    }

    public static ContainerPropertiesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ContainerPropertiesUnmarshaller();
        }
        return INSTANCE;
    }
}

