/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrdersCopier;
import software.amazon.awssdk.services.batch.model.JQState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateJobQueueRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateJobQueueRequest> {
    private final String jobQueue;
    private final String state;
    private final Integer priority;
    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private UpdateJobQueueRequest(BuilderImpl builder) {
        this.jobQueue = builder.jobQueue;
        this.state = builder.state;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    public String jobQueue() {
        return this.jobQueue;
    }

    public String state() {
        return this.state;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return this.computeEnvironmentOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobQueue() == null ? 0 : this.jobQueue().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        hashCode = 31 * hashCode + (this.computeEnvironmentOrder() == null ? 0 : this.computeEnvironmentOrder().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobQueueRequest)) {
            return false;
        }
        UpdateJobQueueRequest other = (UpdateJobQueueRequest)((Object)obj);
        if (other.jobQueue() == null ^ this.jobQueue() == null) {
            return false;
        }
        if (other.jobQueue() != null && !other.jobQueue().equals(this.jobQueue())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.computeEnvironmentOrder() == null ^ this.computeEnvironmentOrder() == null) {
            return false;
        }
        return other.computeEnvironmentOrder() == null || other.computeEnvironmentOrder().equals(this.computeEnvironmentOrder());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobQueue() != null) {
            sb.append("JobQueue: ").append(this.jobQueue()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.computeEnvironmentOrder() != null) {
            sb.append("ComputeEnvironmentOrder: ").append(this.computeEnvironmentOrder()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobQueue;
        private String state;
        private Integer priority;
        private List<ComputeEnvironmentOrder> computeEnvironmentOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobQueueRequest model) {
            this.setJobQueue(model.jobQueue);
            this.setState(model.state);
            this.setPriority(model.priority);
            this.setComputeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(JQState state) {
            this.state(state.toString());
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder> getComputeEnvironmentOrder() {
            return this.computeEnvironmentOrder;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... computeEnvironmentOrder) {
            if (this.computeEnvironmentOrder == null) {
                this.computeEnvironmentOrder = new ArrayList<ComputeEnvironmentOrder>(computeEnvironmentOrder.length);
            }
            for (ComputeEnvironmentOrder e : computeEnvironmentOrder) {
                this.computeEnvironmentOrder.add(e);
            }
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
        }

        @SafeVarargs
        public final void setComputeEnvironmentOrder(ComputeEnvironmentOrder ... computeEnvironmentOrder) {
            if (this.computeEnvironmentOrder == null) {
                this.computeEnvironmentOrder = new ArrayList<ComputeEnvironmentOrder>(computeEnvironmentOrder.length);
            }
            for (ComputeEnvironmentOrder e : computeEnvironmentOrder) {
                this.computeEnvironmentOrder.add(e);
            }
        }

        public UpdateJobQueueRequest build() {
            return new UpdateJobQueueRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateJobQueueRequest> {
        public Builder jobQueue(String var1);

        public Builder state(String var1);

        public Builder state(JQState var1);

        public Builder priority(Integer var1);

        public Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> var1);

        public Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... var1);
    }
}

