/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobQueuesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeJobQueuesRequest> {
    private final List<String> jobQueues;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeJobQueuesRequest(BuilderImpl builder) {
        this.jobQueues = builder.jobQueues;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> jobQueues() {
        return this.jobQueues;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobQueues() == null ? 0 : this.jobQueues().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobQueuesRequest)) {
            return false;
        }
        DescribeJobQueuesRequest other = (DescribeJobQueuesRequest)((Object)obj);
        if (other.jobQueues() == null ^ this.jobQueues() == null) {
            return false;
        }
        if (other.jobQueues() != null && !other.jobQueues().equals(this.jobQueues())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobQueues() != null) {
            sb.append("JobQueues: ").append(this.jobQueues()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> jobQueues;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobQueuesRequest model) {
            this.setJobQueues(model.jobQueues);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getJobQueues() {
            return this.jobQueues;
        }

        @Override
        public final Builder jobQueues(Collection<String> jobQueues) {
            this.jobQueues = StringListCopier.copy(jobQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(String ... jobQueues) {
            if (this.jobQueues == null) {
                this.jobQueues = new ArrayList<String>(jobQueues.length);
            }
            for (String e : jobQueues) {
                this.jobQueues.add(e);
            }
            return this;
        }

        public final void setJobQueues(Collection<String> jobQueues) {
            this.jobQueues = StringListCopier.copy(jobQueues);
        }

        @SafeVarargs
        public final void setJobQueues(String ... jobQueues) {
            if (this.jobQueues == null) {
                this.jobQueues = new ArrayList<String>(jobQueues.length);
            }
            for (String e : jobQueues) {
                this.jobQueues.add(e);
            }
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeJobQueuesRequest build() {
            return new DescribeJobQueuesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobQueuesRequest> {
        public Builder jobQueues(Collection<String> var1);

        public Builder jobQueues(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

