/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.batch.model.JobDefinition;
import software.amazon.awssdk.services.batch.model.JobDefinitionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobDefinitionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeJobDefinitionsResponse> {
    private final List<JobDefinition> jobDefinitions;
    private final String nextToken;

    private DescribeJobDefinitionsResponse(BuilderImpl builder) {
        this.jobDefinitions = builder.jobDefinitions;
        this.nextToken = builder.nextToken;
    }

    public List<JobDefinition> jobDefinitions() {
        return this.jobDefinitions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobDefinitions() == null ? 0 : this.jobDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobDefinitionsResponse)) {
            return false;
        }
        DescribeJobDefinitionsResponse other = (DescribeJobDefinitionsResponse)((Object)obj);
        if (other.jobDefinitions() == null ^ this.jobDefinitions() == null) {
            return false;
        }
        if (other.jobDefinitions() != null && !other.jobDefinitions().equals(this.jobDefinitions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobDefinitions() != null) {
            sb.append("JobDefinitions: ").append(this.jobDefinitions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<JobDefinition> jobDefinitions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobDefinitionsResponse model) {
            this.setJobDefinitions(model.jobDefinitions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<JobDefinition> getJobDefinitions() {
            return this.jobDefinitions;
        }

        @Override
        public final Builder jobDefinitions(Collection<JobDefinition> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copy(jobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(JobDefinition ... jobDefinitions) {
            if (this.jobDefinitions == null) {
                this.jobDefinitions = new ArrayList<JobDefinition>(jobDefinitions.length);
            }
            for (JobDefinition e : jobDefinitions) {
                this.jobDefinitions.add(e);
            }
            return this;
        }

        public final void setJobDefinitions(Collection<JobDefinition> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copy(jobDefinitions);
        }

        @SafeVarargs
        public final void setJobDefinitions(JobDefinition ... jobDefinitions) {
            if (this.jobDefinitions == null) {
                this.jobDefinitions = new ArrayList<JobDefinition>(jobDefinitions.length);
            }
            for (JobDefinition e : jobDefinitions) {
                this.jobDefinitions.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeJobDefinitionsResponse build() {
            return new DescribeJobDefinitionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobDefinitionsResponse> {
        public Builder jobDefinitions(Collection<JobDefinition> var1);

        public Builder jobDefinitions(JobDefinition ... var1);

        public Builder nextToken(String var1);
    }
}

