/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SummaryChecksumAlgorithm {
    SUMMARY("SUMMARY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SummaryChecksumAlgorithm> VALUE_MAP;
    private final String value;

    private SummaryChecksumAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SummaryChecksumAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SummaryChecksumAlgorithm> knownValues() {
        EnumSet<SummaryChecksumAlgorithm> knownValues = EnumSet.allOf(SummaryChecksumAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SummaryChecksumAlgorithm.class, SummaryChecksumAlgorithm::toString);
    }
}

