/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartObjectRequest
extends BackupStorageRequest
implements ToCopyableBuilder<Builder, StartObjectRequest> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupJobId").getter(StartObjectRequest.getter(StartObjectRequest::backupJobId)).setter(StartObjectRequest.setter(Builder::backupJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> OBJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectName").getter(StartObjectRequest.getter(StartObjectRequest::objectName)).setter(StartObjectRequest.setter(Builder::objectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("objectName").build()}).build();
    private static final SdkField<Boolean> THROW_ON_DUPLICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ThrowOnDuplicate").getter(StartObjectRequest.getter(StartObjectRequest::throwOnDuplicate)).setter(StartObjectRequest.setter(Builder::throwOnDuplicate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThrowOnDuplicate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD, OBJECT_NAME_FIELD, THROW_ON_DUPLICATE_FIELD));
    private final String backupJobId;
    private final String objectName;
    private final Boolean throwOnDuplicate;

    private StartObjectRequest(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.objectName = builder.objectName;
        this.throwOnDuplicate = builder.throwOnDuplicate;
    }

    public final String backupJobId() {
        return this.backupJobId;
    }

    public final String objectName() {
        return this.objectName;
    }

    public final Boolean throwOnDuplicate() {
        return this.throwOnDuplicate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.throwOnDuplicate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartObjectRequest)) {
            return false;
        }
        StartObjectRequest other = (StartObjectRequest)((Object)obj);
        return Objects.equals(this.backupJobId(), other.backupJobId()) && Objects.equals(this.objectName(), other.objectName()) && Objects.equals(this.throwOnDuplicate(), other.throwOnDuplicate());
    }

    public final String toString() {
        return ToString.builder((String)"StartObjectRequest").add("BackupJobId", (Object)this.backupJobId()).add("ObjectName", (Object)this.objectName()).add("ThrowOnDuplicate", (Object)this.throwOnDuplicate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupJobId": {
                return Optional.ofNullable(clazz.cast(this.backupJobId()));
            }
            case "ObjectName": {
                return Optional.ofNullable(clazz.cast(this.objectName()));
            }
            case "ThrowOnDuplicate": {
                return Optional.ofNullable(clazz.cast(this.throwOnDuplicate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartObjectRequest, T> g) {
        return obj -> g.apply((StartObjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageRequest.BuilderImpl
    implements Builder {
        private String backupJobId;
        private String objectName;
        private Boolean throwOnDuplicate;

        private BuilderImpl() {
        }

        private BuilderImpl(StartObjectRequest model) {
            super(model);
            this.backupJobId(model.backupJobId);
            this.objectName(model.objectName);
            this.throwOnDuplicate(model.throwOnDuplicate);
        }

        public final String getBackupJobId() {
            return this.backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getObjectName() {
            return this.objectName;
        }

        public final void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        @Override
        public final Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public final Boolean getThrowOnDuplicate() {
            return this.throwOnDuplicate;
        }

        public final void setThrowOnDuplicate(Boolean throwOnDuplicate) {
            this.throwOnDuplicate = throwOnDuplicate;
        }

        @Override
        public final Builder throwOnDuplicate(Boolean throwOnDuplicate) {
            this.throwOnDuplicate = throwOnDuplicate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartObjectRequest build() {
            return new StartObjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartObjectRequest> {
        public Builder backupJobId(String var1);

        public Builder objectName(String var1);

        public Builder throwOnDuplicate(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

