/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageResponse;
import software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetObjectMetadataResponse
extends BackupStorageResponse
implements ToCopyableBuilder<Builder, GetObjectMetadataResponse> {
    private static final SdkField<String> METADATA_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataString").getter(GetObjectMetadataResponse.getter(GetObjectMetadataResponse::metadataString)).setter(GetObjectMetadataResponse.setter(Builder::metadataString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-metadata-string").build()}).build();
    private static final SdkField<Long> METADATA_BLOB_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MetadataBlobLength").getter(GetObjectMetadataResponse.getter(GetObjectMetadataResponse::metadataBlobLength)).setter(GetObjectMetadataResponse.setter(Builder::metadataBlobLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-length").build()}).build();
    private static final SdkField<String> METADATA_BLOB_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataBlobChecksum").getter(GetObjectMetadataResponse.getter(GetObjectMetadataResponse::metadataBlobChecksum)).setter(GetObjectMetadataResponse.setter(Builder::metadataBlobChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-checksum").build()}).build();
    private static final SdkField<String> METADATA_BLOB_CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataBlobChecksumAlgorithm").getter(GetObjectMetadataResponse.getter(GetObjectMetadataResponse::metadataBlobChecksumAlgorithmAsString)).setter(GetObjectMetadataResponse.setter(Builder::metadataBlobChecksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-checksum-algorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_STRING_FIELD, METADATA_BLOB_LENGTH_FIELD, METADATA_BLOB_CHECKSUM_FIELD, METADATA_BLOB_CHECKSUM_ALGORITHM_FIELD));
    private final String metadataString;
    private final Long metadataBlobLength;
    private final String metadataBlobChecksum;
    private final String metadataBlobChecksumAlgorithm;

    private GetObjectMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.metadataString = builder.metadataString;
        this.metadataBlobLength = builder.metadataBlobLength;
        this.metadataBlobChecksum = builder.metadataBlobChecksum;
        this.metadataBlobChecksumAlgorithm = builder.metadataBlobChecksumAlgorithm;
    }

    public final String metadataString() {
        return this.metadataString;
    }

    public final Long metadataBlobLength() {
        return this.metadataBlobLength;
    }

    public final String metadataBlobChecksum() {
        return this.metadataBlobChecksum;
    }

    public final DataChecksumAlgorithm metadataBlobChecksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(this.metadataBlobChecksumAlgorithm);
    }

    public final String metadataBlobChecksumAlgorithmAsString() {
        return this.metadataBlobChecksumAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataBlobLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataBlobChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataBlobChecksumAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectMetadataResponse)) {
            return false;
        }
        GetObjectMetadataResponse other = (GetObjectMetadataResponse)((Object)obj);
        return Objects.equals(this.metadataString(), other.metadataString()) && Objects.equals(this.metadataBlobLength(), other.metadataBlobLength()) && Objects.equals(this.metadataBlobChecksum(), other.metadataBlobChecksum()) && Objects.equals(this.metadataBlobChecksumAlgorithmAsString(), other.metadataBlobChecksumAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetObjectMetadataResponse").add("MetadataString", (Object)this.metadataString()).add("MetadataBlobLength", (Object)this.metadataBlobLength()).add("MetadataBlobChecksum", (Object)this.metadataBlobChecksum()).add("MetadataBlobChecksumAlgorithm", (Object)this.metadataBlobChecksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetadataString": {
                return Optional.ofNullable(clazz.cast(this.metadataString()));
            }
            case "MetadataBlobLength": {
                return Optional.ofNullable(clazz.cast(this.metadataBlobLength()));
            }
            case "MetadataBlobChecksum": {
                return Optional.ofNullable(clazz.cast(this.metadataBlobChecksum()));
            }
            case "MetadataBlobChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.metadataBlobChecksumAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetObjectMetadataResponse, T> g) {
        return obj -> g.apply((GetObjectMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageResponse.BuilderImpl
    implements Builder {
        private String metadataString;
        private Long metadataBlobLength;
        private String metadataBlobChecksum;
        private String metadataBlobChecksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectMetadataResponse model) {
            super(model);
            this.metadataString(model.metadataString);
            this.metadataBlobLength(model.metadataBlobLength);
            this.metadataBlobChecksum(model.metadataBlobChecksum);
            this.metadataBlobChecksumAlgorithm(model.metadataBlobChecksumAlgorithm);
        }

        public final String getMetadataString() {
            return this.metadataString;
        }

        public final void setMetadataString(String metadataString) {
            this.metadataString = metadataString;
        }

        @Override
        public final Builder metadataString(String metadataString) {
            this.metadataString = metadataString;
            return this;
        }

        public final Long getMetadataBlobLength() {
            return this.metadataBlobLength;
        }

        public final void setMetadataBlobLength(Long metadataBlobLength) {
            this.metadataBlobLength = metadataBlobLength;
        }

        @Override
        public final Builder metadataBlobLength(Long metadataBlobLength) {
            this.metadataBlobLength = metadataBlobLength;
            return this;
        }

        public final String getMetadataBlobChecksum() {
            return this.metadataBlobChecksum;
        }

        public final void setMetadataBlobChecksum(String metadataBlobChecksum) {
            this.metadataBlobChecksum = metadataBlobChecksum;
        }

        @Override
        public final Builder metadataBlobChecksum(String metadataBlobChecksum) {
            this.metadataBlobChecksum = metadataBlobChecksum;
            return this;
        }

        public final String getMetadataBlobChecksumAlgorithm() {
            return this.metadataBlobChecksumAlgorithm;
        }

        public final void setMetadataBlobChecksumAlgorithm(String metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm = metadataBlobChecksumAlgorithm;
        }

        @Override
        public final Builder metadataBlobChecksumAlgorithm(String metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm = metadataBlobChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder metadataBlobChecksumAlgorithm(DataChecksumAlgorithm metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm(metadataBlobChecksumAlgorithm == null ? null : metadataBlobChecksumAlgorithm.toString());
            return this;
        }

        @Override
        public GetObjectMetadataResponse build() {
            return new GetObjectMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetObjectMetadataResponse> {
        public Builder metadataString(String var1);

        public Builder metadataBlobLength(Long var1);

        public Builder metadataBlobChecksum(String var1);

        public Builder metadataBlobChecksumAlgorithm(String var1);

        public Builder metadataBlobChecksumAlgorithm(DataChecksumAlgorithm var1);
    }
}

