/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backupstorage.BackupStorageAsyncClient;
import software.amazon.awssdk.services.backupstorage.BackupStorageAsyncClientBuilder;
import software.amazon.awssdk.services.backupstorage.BackupStorageServiceClientConfiguration;
import software.amazon.awssdk.services.backupstorage.DefaultBackupStorageAsyncClient;
import software.amazon.awssdk.services.backupstorage.DefaultBackupStorageBaseClientBuilder;
import software.amazon.awssdk.services.backupstorage.endpoints.BackupStorageEndpointProvider;

@SdkInternalApi
final class DefaultBackupStorageAsyncClientBuilder
extends DefaultBackupStorageBaseClientBuilder<BackupStorageAsyncClientBuilder, BackupStorageAsyncClient>
implements BackupStorageAsyncClientBuilder {
    DefaultBackupStorageAsyncClientBuilder() {
    }

    @Override
    public DefaultBackupStorageAsyncClientBuilder endpointProvider(BackupStorageEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BackupStorageAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultBackupStorageAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        BackupStorageServiceClientConfiguration serviceClientConfiguration = BackupStorageServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultBackupStorageAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

