/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutChunkRequest extends BackupStorageRequest implements
        ToCopyableBuilder<PutChunkRequest.Builder, PutChunkRequest> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupJobId").getter(getter(PutChunkRequest::backupJobId)).setter(setter(Builder::backupJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UploadId").getter(getter(PutChunkRequest::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("uploadId").build()).build();

    private static final SdkField<Long> CHUNK_INDEX_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ChunkIndex").getter(getter(PutChunkRequest::chunkIndex)).setter(setter(Builder::chunkIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("chunkIndex").build()).build();

    private static final SdkField<Long> LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Length")
            .getter(getter(PutChunkRequest::length)).setter(setter(Builder::length))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("length").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Checksum").getter(getter(PutChunkRequest::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum").build()).build();

    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChecksumAlgorithm").getter(getter(PutChunkRequest::checksumAlgorithmAsString))
            .setter(setter(Builder::checksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum-algorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD,
            UPLOAD_ID_FIELD, CHUNK_INDEX_FIELD, LENGTH_FIELD, CHECKSUM_FIELD, CHECKSUM_ALGORITHM_FIELD));

    private final String backupJobId;

    private final String uploadId;

    private final Long chunkIndex;

    private final Long length;

    private final String checksum;

    private final String checksumAlgorithm;

    private PutChunkRequest(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.uploadId = builder.uploadId;
        this.chunkIndex = builder.chunkIndex;
        this.length = builder.length;
        this.checksum = builder.checksum;
        this.checksumAlgorithm = builder.checksumAlgorithm;
    }

    /**
     * Backup job Id for the in-progress backup.
     * 
     * @return Backup job Id for the in-progress backup.
     */
    public final String backupJobId() {
        return backupJobId;
    }

    /**
     * Upload Id for the in-progress upload.
     * 
     * @return Upload Id for the in-progress upload.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * Describes this chunk's position relative to the other chunks
     * 
     * @return Describes this chunk's position relative to the other chunks
     */
    public final Long chunkIndex() {
        return chunkIndex;
    }

    /**
     * Data length
     * 
     * @return Data length
     */
    public final Long length() {
        return length;
    }

    /**
     * Data checksum
     * 
     * @return Data checksum
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * Checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checksumAlgorithm}
     * will return {@link DataChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #checksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm
     * @see DataChecksumAlgorithm
     */
    public final DataChecksumAlgorithm checksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(checksumAlgorithm);
    }

    /**
     * Checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checksumAlgorithm}
     * will return {@link DataChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #checksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm
     * @see DataChecksumAlgorithm
     */
    public final String checksumAlgorithmAsString() {
        return checksumAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(chunkIndex());
        hashCode = 31 * hashCode + Objects.hashCode(length());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(checksumAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutChunkRequest)) {
            return false;
        }
        PutChunkRequest other = (PutChunkRequest) obj;
        return Objects.equals(backupJobId(), other.backupJobId()) && Objects.equals(uploadId(), other.uploadId())
                && Objects.equals(chunkIndex(), other.chunkIndex()) && Objects.equals(length(), other.length())
                && Objects.equals(checksum(), other.checksum())
                && Objects.equals(checksumAlgorithmAsString(), other.checksumAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutChunkRequest").add("BackupJobId", backupJobId()).add("UploadId", uploadId())
                .add("ChunkIndex", chunkIndex()).add("Length", length()).add("Checksum", checksum())
                .add("ChecksumAlgorithm", checksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupJobId":
            return Optional.ofNullable(clazz.cast(backupJobId()));
        case "UploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "ChunkIndex":
            return Optional.ofNullable(clazz.cast(chunkIndex()));
        case "Length":
            return Optional.ofNullable(clazz.cast(length()));
        case "Checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "ChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(checksumAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutChunkRequest, T> g) {
        return obj -> g.apply((PutChunkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutChunkRequest> {
        /**
         * Backup job Id for the in-progress backup.
         * 
         * @param backupJobId
         *        Backup job Id for the in-progress backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupJobId(String backupJobId);

        /**
         * Upload Id for the in-progress upload.
         * 
         * @param uploadId
         *        Upload Id for the in-progress upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * Describes this chunk's position relative to the other chunks
         * 
         * @param chunkIndex
         *        Describes this chunk's position relative to the other chunks
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chunkIndex(Long chunkIndex);

        /**
         * Data length
         * 
         * @param length
         *        Data length
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder length(Long length);

        /**
         * Data checksum
         * 
         * @param checksum
         *        Data checksum
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * Checksum algorithm
         * 
         * @param checksumAlgorithm
         *        Checksum algorithm
         * @see DataChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataChecksumAlgorithm
         */
        Builder checksumAlgorithm(String checksumAlgorithm);

        /**
         * Checksum algorithm
         * 
         * @param checksumAlgorithm
         *        Checksum algorithm
         * @see DataChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataChecksumAlgorithm
         */
        Builder checksumAlgorithm(DataChecksumAlgorithm checksumAlgorithm);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupStorageRequest.BuilderImpl implements Builder {
        private String backupJobId;

        private String uploadId;

        private Long chunkIndex;

        private Long length;

        private String checksum;

        private String checksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(PutChunkRequest model) {
            super(model);
            backupJobId(model.backupJobId);
            uploadId(model.uploadId);
            chunkIndex(model.chunkIndex);
            length(model.length);
            checksum(model.checksum);
            checksumAlgorithm(model.checksumAlgorithm);
        }

        public final String getBackupJobId() {
            return backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final Long getChunkIndex() {
            return chunkIndex;
        }

        public final void setChunkIndex(Long chunkIndex) {
            this.chunkIndex = chunkIndex;
        }

        @Override
        public final Builder chunkIndex(Long chunkIndex) {
            this.chunkIndex = chunkIndex;
            return this;
        }

        public final Long getLength() {
            return length;
        }

        public final void setLength(Long length) {
            this.length = length;
        }

        @Override
        public final Builder length(Long length) {
            this.length = length;
            return this;
        }

        public final String getChecksum() {
            return checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getChecksumAlgorithm() {
            return checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        public final Builder checksumAlgorithm(DataChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutChunkRequest build() {
            return new PutChunkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
