/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChunksResponse extends BackupStorageResponse implements
        ToCopyableBuilder<ListChunksResponse.Builder, ListChunksResponse> {
    private static final SdkField<List<Chunk>> CHUNK_LIST_FIELD = SdkField
            .<List<Chunk>> builder(MarshallingType.LIST)
            .memberName("ChunkList")
            .getter(getter(ListChunksResponse::chunkList))
            .setter(setter(Builder::chunkList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChunkList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Chunk> builder(MarshallingType.SDK_POJO)
                                            .constructor(Chunk::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChunksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHUNK_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Chunk> chunkList;

    private final String nextToken;

    private ListChunksResponse(BuilderImpl builder) {
        super(builder);
        this.chunkList = builder.chunkList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChunkList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChunkList() {
        return chunkList != null && !(chunkList instanceof SdkAutoConstructList);
    }

    /**
     * List of chunks
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChunkList} method.
     * </p>
     * 
     * @return List of chunks
     */
    public final List<Chunk> chunkList() {
        return chunkList;
    }

    /**
     * Pagination token
     * 
     * @return Pagination token
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChunkList() ? chunkList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChunksResponse)) {
            return false;
        }
        ListChunksResponse other = (ListChunksResponse) obj;
        return hasChunkList() == other.hasChunkList() && Objects.equals(chunkList(), other.chunkList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChunksResponse").add("ChunkList", hasChunkList() ? chunkList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChunkList":
            return Optional.ofNullable(clazz.cast(chunkList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChunksResponse, T> g) {
        return obj -> g.apply((ListChunksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListChunksResponse> {
        /**
         * List of chunks
         * 
         * @param chunkList
         *        List of chunks
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chunkList(Collection<Chunk> chunkList);

        /**
         * List of chunks
         * 
         * @param chunkList
         *        List of chunks
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chunkList(Chunk... chunkList);

        /**
         * List of chunks This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupstorage.model.Chunk.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.backupstorage.model.Chunk#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupstorage.model.Chunk.Builder#build()} is called immediately and
         * its result is passed to {@link #chunkList(List<Chunk>)}.
         * 
         * @param chunkList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupstorage.model.Chunk.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chunkList(java.util.Collection<Chunk>)
         */
        Builder chunkList(Consumer<Chunk.Builder>... chunkList);

        /**
         * Pagination token
         * 
         * @param nextToken
         *        Pagination token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupStorageResponse.BuilderImpl implements Builder {
        private List<Chunk> chunkList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChunksResponse model) {
            super(model);
            chunkList(model.chunkList);
            nextToken(model.nextToken);
        }

        public final List<Chunk.Builder> getChunkList() {
            List<Chunk.Builder> result = ChunkListCopier.copyToBuilder(this.chunkList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChunkList(Collection<Chunk.BuilderImpl> chunkList) {
            this.chunkList = ChunkListCopier.copyFromBuilder(chunkList);
        }

        @Override
        public final Builder chunkList(Collection<Chunk> chunkList) {
            this.chunkList = ChunkListCopier.copy(chunkList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chunkList(Chunk... chunkList) {
            chunkList(Arrays.asList(chunkList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chunkList(Consumer<Chunk.Builder>... chunkList) {
            chunkList(Stream.of(chunkList).map(c -> Chunk.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChunksResponse build() {
            return new ListChunksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
