/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteObjectRequest
extends BackupStorageRequest
implements ToCopyableBuilder<Builder, DeleteObjectRequest> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupJobId").getter(DeleteObjectRequest.getter(DeleteObjectRequest::backupJobId)).setter(DeleteObjectRequest.setter(Builder::backupJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> OBJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectName").getter(DeleteObjectRequest.getter(DeleteObjectRequest::objectName)).setter(DeleteObjectRequest.setter(Builder::objectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("objectName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD, OBJECT_NAME_FIELD));
    private final String backupJobId;
    private final String objectName;

    private DeleteObjectRequest(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.objectName = builder.objectName;
    }

    public final String backupJobId() {
        return this.backupJobId;
    }

    public final String objectName() {
        return this.objectName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectRequest)) {
            return false;
        }
        DeleteObjectRequest other = (DeleteObjectRequest)((Object)obj);
        return Objects.equals(this.backupJobId(), other.backupJobId()) && Objects.equals(this.objectName(), other.objectName());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteObjectRequest").add("BackupJobId", (Object)this.backupJobId()).add("ObjectName", (Object)this.objectName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupJobId": {
                return Optional.ofNullable(clazz.cast(this.backupJobId()));
            }
            case "ObjectName": {
                return Optional.ofNullable(clazz.cast(this.objectName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteObjectRequest, T> g) {
        return obj -> g.apply((DeleteObjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageRequest.BuilderImpl
    implements Builder {
        private String backupJobId;
        private String objectName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectRequest model) {
            super(model);
            this.backupJobId(model.backupJobId);
            this.objectName(model.objectName);
        }

        public final String getBackupJobId() {
            return this.backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getObjectName() {
            return this.objectName;
        }

        public final void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        @Override
        public final Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteObjectRequest build() {
            return new DeleteObjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteObjectRequest> {
        public Builder backupJobId(String var1);

        public Builder objectName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

