/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupsearch.BackupSearchClient;
import software.amazon.awssdk.services.backupsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobsResponse;
import software.amazon.awssdk.services.backupsearch.model.SearchJobSummary;

public class ListSearchJobsIterable
implements SdkIterable<ListSearchJobsResponse> {
    private final BackupSearchClient client;
    private final ListSearchJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSearchJobsIterable(BackupSearchClient client, ListSearchJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSearchJobsResponseFetcher();
    }

    public Iterator<ListSearchJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchJobSummary> searchJobs() {
        Function<ListSearchJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.searchJobs() != null) {
                return response.searchJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSearchJobsResponseFetcher
    implements SyncPageFetcher<ListSearchJobsResponse> {
        private ListSearchJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSearchJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSearchJobsResponse nextPage(ListSearchJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSearchJobsIterable.this.client.listSearchJobs(ListSearchJobsIterable.this.firstRequest);
            }
            return ListSearchJobsIterable.this.client.listSearchJobs((ListSearchJobsRequest)((Object)ListSearchJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

