/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupsearch.model.BackupSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSearchJobResponse
extends BackupSearchResponse
implements ToCopyableBuilder<Builder, StartSearchJobResponse> {
    private static final SdkField<String> SEARCH_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchJobArn").getter(StartSearchJobResponse.getter(StartSearchJobResponse::searchJobArn)).setter(StartSearchJobResponse.setter(Builder::searchJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(StartSearchJobResponse.getter(StartSearchJobResponse::creationTime)).setter(StartSearchJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> SEARCH_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchJobIdentifier").getter(StartSearchJobResponse.getter(StartSearchJobResponse::searchJobIdentifier)).setter(StartSearchJobResponse.setter(Builder::searchJobIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_JOB_ARN_FIELD, CREATION_TIME_FIELD, SEARCH_JOB_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartSearchJobResponse.memberNameToFieldInitializer();
    private final String searchJobArn;
    private final Instant creationTime;
    private final String searchJobIdentifier;

    private StartSearchJobResponse(BuilderImpl builder) {
        super(builder);
        this.searchJobArn = builder.searchJobArn;
        this.creationTime = builder.creationTime;
        this.searchJobIdentifier = builder.searchJobIdentifier;
    }

    public final String searchJobArn() {
        return this.searchJobArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String searchJobIdentifier() {
        return this.searchJobIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.searchJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchJobIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSearchJobResponse)) {
            return false;
        }
        StartSearchJobResponse other = (StartSearchJobResponse)((Object)obj);
        return Objects.equals(this.searchJobArn(), other.searchJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.searchJobIdentifier(), other.searchJobIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"StartSearchJobResponse").add("SearchJobArn", (Object)this.searchJobArn()).add("CreationTime", (Object)this.creationTime()).add("SearchJobIdentifier", (Object)this.searchJobIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchJobArn": {
                return Optional.ofNullable(clazz.cast(this.searchJobArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "SearchJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.searchJobIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SearchJobArn", SEARCH_JOB_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("SearchJobIdentifier", SEARCH_JOB_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSearchJobResponse, T> g) {
        return obj -> g.apply((StartSearchJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupSearchResponse.BuilderImpl
    implements Builder {
        private String searchJobArn;
        private Instant creationTime;
        private String searchJobIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSearchJobResponse model) {
            super(model);
            this.searchJobArn(model.searchJobArn);
            this.creationTime(model.creationTime);
            this.searchJobIdentifier(model.searchJobIdentifier);
        }

        public final String getSearchJobArn() {
            return this.searchJobArn;
        }

        public final void setSearchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
        }

        @Override
        public final Builder searchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getSearchJobIdentifier() {
            return this.searchJobIdentifier;
        }

        public final void setSearchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
        }

        @Override
        public final Builder searchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
            return this;
        }

        @Override
        public StartSearchJobResponse build() {
            return new StartSearchJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSearchJobResponse> {
        public Builder searchJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder searchJobIdentifier(String var1);
    }
}

