/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupsearch.model.LongCondition;
import software.amazon.awssdk.services.backupsearch.model.LongConditionListCopier;
import software.amazon.awssdk.services.backupsearch.model.StringCondition;
import software.amazon.awssdk.services.backupsearch.model.StringConditionListCopier;
import software.amazon.awssdk.services.backupsearch.model.TimeCondition;
import software.amazon.awssdk.services.backupsearch.model.TimeConditionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EBSItemFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EBSItemFilter> {
    private static final SdkField<List<StringCondition>> FILE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilePaths").getter(EBSItemFilter.getter(EBSItemFilter::filePaths)).setter(EBSItemFilter.setter(Builder::filePaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LongCondition>> SIZES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sizes").getter(EBSItemFilter.getter(EBSItemFilter::sizes)).setter(EBSItemFilter.setter(Builder::sizes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sizes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LongCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TimeCondition>> CREATION_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreationTimes").getter(EBSItemFilter.getter(EBSItemFilter::creationTimes)).setter(EBSItemFilter.setter(Builder::creationTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TimeCondition>> LAST_MODIFICATION_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LastModificationTimes").getter(EBSItemFilter.getter(EBSItemFilter::lastModificationTimes)).setter(EBSItemFilter.setter(Builder::lastModificationTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATHS_FIELD, SIZES_FIELD, CREATION_TIMES_FIELD, LAST_MODIFICATION_TIMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EBSItemFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StringCondition> filePaths;
    private final List<LongCondition> sizes;
    private final List<TimeCondition> creationTimes;
    private final List<TimeCondition> lastModificationTimes;

    private EBSItemFilter(BuilderImpl builder) {
        this.filePaths = builder.filePaths;
        this.sizes = builder.sizes;
        this.creationTimes = builder.creationTimes;
        this.lastModificationTimes = builder.lastModificationTimes;
    }

    public final boolean hasFilePaths() {
        return this.filePaths != null && !(this.filePaths instanceof SdkAutoConstructList);
    }

    public final List<StringCondition> filePaths() {
        return this.filePaths;
    }

    public final boolean hasSizes() {
        return this.sizes != null && !(this.sizes instanceof SdkAutoConstructList);
    }

    public final List<LongCondition> sizes() {
        return this.sizes;
    }

    public final boolean hasCreationTimes() {
        return this.creationTimes != null && !(this.creationTimes instanceof SdkAutoConstructList);
    }

    public final List<TimeCondition> creationTimes() {
        return this.creationTimes;
    }

    public final boolean hasLastModificationTimes() {
        return this.lastModificationTimes != null && !(this.lastModificationTimes instanceof SdkAutoConstructList);
    }

    public final List<TimeCondition> lastModificationTimes() {
        return this.lastModificationTimes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilePaths() ? this.filePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSizes() ? this.sizes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreationTimes() ? this.creationTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastModificationTimes() ? this.lastModificationTimes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSItemFilter)) {
            return false;
        }
        EBSItemFilter other = (EBSItemFilter)obj;
        return this.hasFilePaths() == other.hasFilePaths() && Objects.equals(this.filePaths(), other.filePaths()) && this.hasSizes() == other.hasSizes() && Objects.equals(this.sizes(), other.sizes()) && this.hasCreationTimes() == other.hasCreationTimes() && Objects.equals(this.creationTimes(), other.creationTimes()) && this.hasLastModificationTimes() == other.hasLastModificationTimes() && Objects.equals(this.lastModificationTimes(), other.lastModificationTimes());
    }

    public final String toString() {
        return ToString.builder((String)"EBSItemFilter").add("FilePaths", this.hasFilePaths() ? this.filePaths() : null).add("Sizes", this.hasSizes() ? this.sizes() : null).add("CreationTimes", this.hasCreationTimes() ? this.creationTimes() : null).add("LastModificationTimes", this.hasLastModificationTimes() ? this.lastModificationTimes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilePaths": {
                return Optional.ofNullable(clazz.cast(this.filePaths()));
            }
            case "Sizes": {
                return Optional.ofNullable(clazz.cast(this.sizes()));
            }
            case "CreationTimes": {
                return Optional.ofNullable(clazz.cast(this.creationTimes()));
            }
            case "LastModificationTimes": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTimes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FilePaths", FILE_PATHS_FIELD);
        map.put("Sizes", SIZES_FIELD);
        map.put("CreationTimes", CREATION_TIMES_FIELD);
        map.put("LastModificationTimes", LAST_MODIFICATION_TIMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EBSItemFilter, T> g) {
        return obj -> g.apply((EBSItemFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringCondition> filePaths = DefaultSdkAutoConstructList.getInstance();
        private List<LongCondition> sizes = DefaultSdkAutoConstructList.getInstance();
        private List<TimeCondition> creationTimes = DefaultSdkAutoConstructList.getInstance();
        private List<TimeCondition> lastModificationTimes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EBSItemFilter model) {
            this.filePaths(model.filePaths);
            this.sizes(model.sizes);
            this.creationTimes(model.creationTimes);
            this.lastModificationTimes(model.lastModificationTimes);
        }

        public final List<StringCondition.Builder> getFilePaths() {
            List<StringCondition.Builder> result = StringConditionListCopier.copyToBuilder(this.filePaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilePaths(Collection<StringCondition.BuilderImpl> filePaths) {
            this.filePaths = StringConditionListCopier.copyFromBuilder(filePaths);
        }

        @Override
        public final Builder filePaths(Collection<StringCondition> filePaths) {
            this.filePaths = StringConditionListCopier.copy(filePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filePaths(StringCondition ... filePaths) {
            this.filePaths(Arrays.asList(filePaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filePaths(Consumer<StringCondition.Builder> ... filePaths) {
            this.filePaths(Stream.of(filePaths).map(c -> (StringCondition)((StringCondition.Builder)StringCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LongCondition.Builder> getSizes() {
            List<LongCondition.Builder> result = LongConditionListCopier.copyToBuilder(this.sizes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSizes(Collection<LongCondition.BuilderImpl> sizes) {
            this.sizes = LongConditionListCopier.copyFromBuilder(sizes);
        }

        @Override
        public final Builder sizes(Collection<LongCondition> sizes) {
            this.sizes = LongConditionListCopier.copy(sizes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizes(LongCondition ... sizes) {
            this.sizes(Arrays.asList(sizes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizes(Consumer<LongCondition.Builder> ... sizes) {
            this.sizes(Stream.of(sizes).map(c -> (LongCondition)((LongCondition.Builder)LongCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TimeCondition.Builder> getCreationTimes() {
            List<TimeCondition.Builder> result = TimeConditionListCopier.copyToBuilder(this.creationTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreationTimes(Collection<TimeCondition.BuilderImpl> creationTimes) {
            this.creationTimes = TimeConditionListCopier.copyFromBuilder(creationTimes);
        }

        @Override
        public final Builder creationTimes(Collection<TimeCondition> creationTimes) {
            this.creationTimes = TimeConditionListCopier.copy(creationTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creationTimes(TimeCondition ... creationTimes) {
            this.creationTimes(Arrays.asList(creationTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creationTimes(Consumer<TimeCondition.Builder> ... creationTimes) {
            this.creationTimes(Stream.of(creationTimes).map(c -> (TimeCondition)((TimeCondition.Builder)TimeCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TimeCondition.Builder> getLastModificationTimes() {
            List<TimeCondition.Builder> result = TimeConditionListCopier.copyToBuilder(this.lastModificationTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastModificationTimes(Collection<TimeCondition.BuilderImpl> lastModificationTimes) {
            this.lastModificationTimes = TimeConditionListCopier.copyFromBuilder(lastModificationTimes);
        }

        @Override
        public final Builder lastModificationTimes(Collection<TimeCondition> lastModificationTimes) {
            this.lastModificationTimes = TimeConditionListCopier.copy(lastModificationTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastModificationTimes(TimeCondition ... lastModificationTimes) {
            this.lastModificationTimes(Arrays.asList(lastModificationTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastModificationTimes(Consumer<TimeCondition.Builder> ... lastModificationTimes) {
            this.lastModificationTimes(Stream.of(lastModificationTimes).map(c -> (TimeCondition)((TimeCondition.Builder)TimeCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EBSItemFilter build() {
            return new EBSItemFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EBSItemFilter> {
        public Builder filePaths(Collection<StringCondition> var1);

        public Builder filePaths(StringCondition ... var1);

        public Builder filePaths(Consumer<StringCondition.Builder> ... var1);

        public Builder sizes(Collection<LongCondition> var1);

        public Builder sizes(LongCondition ... var1);

        public Builder sizes(Consumer<LongCondition.Builder> ... var1);

        public Builder creationTimes(Collection<TimeCondition> var1);

        public Builder creationTimes(TimeCondition ... var1);

        public Builder creationTimes(Consumer<TimeCondition.Builder> ... var1);

        public Builder lastModificationTimes(Collection<TimeCondition> var1);

        public Builder lastModificationTimes(TimeCondition ... var1);

        public Builder lastModificationTimes(Consumer<TimeCondition.Builder> ... var1);
    }
}

