/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupgateway.model.GatewayType;
import software.amazon.awssdk.services.backupgateway.model.MaintenanceStartTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatewayDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatewayDetails> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayArn").getter(GatewayDetails.getter(GatewayDetails::gatewayArn)).setter(GatewayDetails.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()}).build();
    private static final SdkField<String> GATEWAY_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayDisplayName").getter(GatewayDetails.getter(GatewayDetails::gatewayDisplayName)).setter(GatewayDetails.setter(Builder::gatewayDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayDisplayName").build()}).build();
    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayType").getter(GatewayDetails.getter(GatewayDetails::gatewayTypeAsString)).setter(GatewayDetails.setter(Builder::gatewayType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()}).build();
    private static final SdkField<String> HYPERVISOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HypervisorId").getter(GatewayDetails.getter(GatewayDetails::hypervisorId)).setter(GatewayDetails.setter(Builder::hypervisorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorId").build()}).build();
    private static final SdkField<Instant> LAST_SEEN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSeenTime").getter(GatewayDetails.getter(GatewayDetails::lastSeenTime)).setter(GatewayDetails.setter(Builder::lastSeenTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSeenTime").build()}).build();
    private static final SdkField<MaintenanceStartTime> MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceStartTime").getter(GatewayDetails.getter(GatewayDetails::maintenanceStartTime)).setter(GatewayDetails.setter(Builder::maintenanceStartTime)).constructor(MaintenanceStartTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceStartTime").build()}).build();
    private static final SdkField<Instant> NEXT_UPDATE_AVAILABILITY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NextUpdateAvailabilityTime").getter(GatewayDetails.getter(GatewayDetails::nextUpdateAvailabilityTime)).setter(GatewayDetails.setter(Builder::nextUpdateAvailabilityTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextUpdateAvailabilityTime").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpoint").getter(GatewayDetails.getter(GatewayDetails::vpcEndpoint)).setter(GatewayDetails.setter(Builder::vpcEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, GATEWAY_DISPLAY_NAME_FIELD, GATEWAY_TYPE_FIELD, HYPERVISOR_ID_FIELD, LAST_SEEN_TIME_FIELD, MAINTENANCE_START_TIME_FIELD, NEXT_UPDATE_AVAILABILITY_TIME_FIELD, VPC_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GatewayDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String gatewayArn;
    private final String gatewayDisplayName;
    private final String gatewayType;
    private final String hypervisorId;
    private final Instant lastSeenTime;
    private final MaintenanceStartTime maintenanceStartTime;
    private final Instant nextUpdateAvailabilityTime;
    private final String vpcEndpoint;

    private GatewayDetails(BuilderImpl builder) {
        this.gatewayArn = builder.gatewayArn;
        this.gatewayDisplayName = builder.gatewayDisplayName;
        this.gatewayType = builder.gatewayType;
        this.hypervisorId = builder.hypervisorId;
        this.lastSeenTime = builder.lastSeenTime;
        this.maintenanceStartTime = builder.maintenanceStartTime;
        this.nextUpdateAvailabilityTime = builder.nextUpdateAvailabilityTime;
        this.vpcEndpoint = builder.vpcEndpoint;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final String gatewayDisplayName() {
        return this.gatewayDisplayName;
    }

    public final GatewayType gatewayType() {
        return GatewayType.fromValue(this.gatewayType);
    }

    public final String gatewayTypeAsString() {
        return this.gatewayType;
    }

    public final String hypervisorId() {
        return this.hypervisorId;
    }

    public final Instant lastSeenTime() {
        return this.lastSeenTime;
    }

    public final MaintenanceStartTime maintenanceStartTime() {
        return this.maintenanceStartTime;
    }

    public final Instant nextUpdateAvailabilityTime() {
        return this.nextUpdateAvailabilityTime;
    }

    public final String vpcEndpoint() {
        return this.vpcEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSeenTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextUpdateAvailabilityTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayDetails)) {
            return false;
        }
        GatewayDetails other = (GatewayDetails)obj;
        return Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.gatewayDisplayName(), other.gatewayDisplayName()) && Objects.equals(this.gatewayTypeAsString(), other.gatewayTypeAsString()) && Objects.equals(this.hypervisorId(), other.hypervisorId()) && Objects.equals(this.lastSeenTime(), other.lastSeenTime()) && Objects.equals(this.maintenanceStartTime(), other.maintenanceStartTime()) && Objects.equals(this.nextUpdateAvailabilityTime(), other.nextUpdateAvailabilityTime()) && Objects.equals(this.vpcEndpoint(), other.vpcEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"GatewayDetails").add("GatewayArn", (Object)this.gatewayArn()).add("GatewayDisplayName", (Object)this.gatewayDisplayName()).add("GatewayType", (Object)this.gatewayTypeAsString()).add("HypervisorId", (Object)this.hypervisorId()).add("LastSeenTime", (Object)this.lastSeenTime()).add("MaintenanceStartTime", (Object)this.maintenanceStartTime()).add("NextUpdateAvailabilityTime", (Object)this.nextUpdateAvailabilityTime()).add("VpcEndpoint", (Object)this.vpcEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "GatewayDisplayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayDisplayName()));
            }
            case "GatewayType": {
                return Optional.ofNullable(clazz.cast(this.gatewayTypeAsString()));
            }
            case "HypervisorId": {
                return Optional.ofNullable(clazz.cast(this.hypervisorId()));
            }
            case "LastSeenTime": {
                return Optional.ofNullable(clazz.cast(this.lastSeenTime()));
            }
            case "MaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.maintenanceStartTime()));
            }
            case "NextUpdateAvailabilityTime": {
                return Optional.ofNullable(clazz.cast(this.nextUpdateAvailabilityTime()));
            }
            case "VpcEndpoint": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayArn", GATEWAY_ARN_FIELD);
        map.put("GatewayDisplayName", GATEWAY_DISPLAY_NAME_FIELD);
        map.put("GatewayType", GATEWAY_TYPE_FIELD);
        map.put("HypervisorId", HYPERVISOR_ID_FIELD);
        map.put("LastSeenTime", LAST_SEEN_TIME_FIELD);
        map.put("MaintenanceStartTime", MAINTENANCE_START_TIME_FIELD);
        map.put("NextUpdateAvailabilityTime", NEXT_UPDATE_AVAILABILITY_TIME_FIELD);
        map.put("VpcEndpoint", VPC_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatewayDetails, T> g) {
        return obj -> g.apply((GatewayDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayArn;
        private String gatewayDisplayName;
        private String gatewayType;
        private String hypervisorId;
        private Instant lastSeenTime;
        private MaintenanceStartTime maintenanceStartTime;
        private Instant nextUpdateAvailabilityTime;
        private String vpcEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayDetails model) {
            this.gatewayArn(model.gatewayArn);
            this.gatewayDisplayName(model.gatewayDisplayName);
            this.gatewayType(model.gatewayType);
            this.hypervisorId(model.hypervisorId);
            this.lastSeenTime(model.lastSeenTime);
            this.maintenanceStartTime(model.maintenanceStartTime);
            this.nextUpdateAvailabilityTime(model.nextUpdateAvailabilityTime);
            this.vpcEndpoint(model.vpcEndpoint);
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getGatewayDisplayName() {
            return this.gatewayDisplayName;
        }

        public final void setGatewayDisplayName(String gatewayDisplayName) {
            this.gatewayDisplayName = gatewayDisplayName;
        }

        @Override
        public final Builder gatewayDisplayName(String gatewayDisplayName) {
            this.gatewayDisplayName = gatewayDisplayName;
            return this;
        }

        public final String getGatewayType() {
            return this.gatewayType;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        @Override
        public final Builder gatewayType(GatewayType gatewayType) {
            this.gatewayType(gatewayType == null ? null : gatewayType.toString());
            return this;
        }

        public final String getHypervisorId() {
            return this.hypervisorId;
        }

        public final void setHypervisorId(String hypervisorId) {
            this.hypervisorId = hypervisorId;
        }

        @Override
        public final Builder hypervisorId(String hypervisorId) {
            this.hypervisorId = hypervisorId;
            return this;
        }

        public final Instant getLastSeenTime() {
            return this.lastSeenTime;
        }

        public final void setLastSeenTime(Instant lastSeenTime) {
            this.lastSeenTime = lastSeenTime;
        }

        @Override
        public final Builder lastSeenTime(Instant lastSeenTime) {
            this.lastSeenTime = lastSeenTime;
            return this;
        }

        public final MaintenanceStartTime.Builder getMaintenanceStartTime() {
            return this.maintenanceStartTime != null ? this.maintenanceStartTime.toBuilder() : null;
        }

        public final void setMaintenanceStartTime(MaintenanceStartTime.BuilderImpl maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime != null ? maintenanceStartTime.build() : null;
        }

        @Override
        public final Builder maintenanceStartTime(MaintenanceStartTime maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
            return this;
        }

        public final Instant getNextUpdateAvailabilityTime() {
            return this.nextUpdateAvailabilityTime;
        }

        public final void setNextUpdateAvailabilityTime(Instant nextUpdateAvailabilityTime) {
            this.nextUpdateAvailabilityTime = nextUpdateAvailabilityTime;
        }

        @Override
        public final Builder nextUpdateAvailabilityTime(Instant nextUpdateAvailabilityTime) {
            this.nextUpdateAvailabilityTime = nextUpdateAvailabilityTime;
            return this;
        }

        public final String getVpcEndpoint() {
            return this.vpcEndpoint;
        }

        public final void setVpcEndpoint(String vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
        }

        @Override
        public final Builder vpcEndpoint(String vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public GatewayDetails build() {
            return new GatewayDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatewayDetails> {
        public Builder gatewayArn(String var1);

        public Builder gatewayDisplayName(String var1);

        public Builder gatewayType(String var1);

        public Builder gatewayType(GatewayType var1);

        public Builder hypervisorId(String var1);

        public Builder lastSeenTime(Instant var1);

        public Builder maintenanceStartTime(MaintenanceStartTime var1);

        default public Builder maintenanceStartTime(Consumer<MaintenanceStartTime.Builder> maintenanceStartTime) {
            return this.maintenanceStartTime((MaintenanceStartTime)((MaintenanceStartTime.Builder)MaintenanceStartTime.builder().applyMutation(maintenanceStartTime)).build());
        }

        public Builder nextUpdateAvailabilityTime(Instant var1);

        public Builder vpcEndpoint(String var1);
    }
}

