/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.VirtualMachine;
import software.amazon.awssdk.services.backupgateway.model.VirtualMachinesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVirtualMachinesResponse
extends BackupGatewayResponse
implements ToCopyableBuilder<Builder, ListVirtualMachinesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVirtualMachinesResponse.getter(ListVirtualMachinesResponse::nextToken)).setter(ListVirtualMachinesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<VirtualMachine>> VIRTUAL_MACHINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VirtualMachines").getter(ListVirtualMachinesResponse.getter(ListVirtualMachinesResponse::virtualMachines)).setter(ListVirtualMachinesResponse.setter(Builder::virtualMachines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualMachines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VirtualMachine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VIRTUAL_MACHINES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("VirtualMachines", VIRTUAL_MACHINES_FIELD);
        }
    });
    private final String nextToken;
    private final List<VirtualMachine> virtualMachines;

    private ListVirtualMachinesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.virtualMachines = builder.virtualMachines;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVirtualMachines() {
        return this.virtualMachines != null && !(this.virtualMachines instanceof SdkAutoConstructList);
    }

    public final List<VirtualMachine> virtualMachines() {
        return this.virtualMachines;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVirtualMachines() ? this.virtualMachines() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualMachinesResponse)) {
            return false;
        }
        ListVirtualMachinesResponse other = (ListVirtualMachinesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVirtualMachines() == other.hasVirtualMachines() && Objects.equals(this.virtualMachines(), other.virtualMachines());
    }

    public final String toString() {
        return ToString.builder((String)"ListVirtualMachinesResponse").add("NextToken", (Object)this.nextToken()).add("VirtualMachines", this.hasVirtualMachines() ? this.virtualMachines() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "VirtualMachines": {
                return Optional.ofNullable(clazz.cast(this.virtualMachines()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualMachinesResponse, T> g) {
        return obj -> g.apply((ListVirtualMachinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupGatewayResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VirtualMachine> virtualMachines = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualMachinesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.virtualMachines(model.virtualMachines);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VirtualMachine.Builder> getVirtualMachines() {
            List<VirtualMachine.Builder> result = VirtualMachinesCopier.copyToBuilder(this.virtualMachines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVirtualMachines(Collection<VirtualMachine.BuilderImpl> virtualMachines) {
            this.virtualMachines = VirtualMachinesCopier.copyFromBuilder(virtualMachines);
        }

        @Override
        public final Builder virtualMachines(Collection<VirtualMachine> virtualMachines) {
            this.virtualMachines = VirtualMachinesCopier.copy(virtualMachines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualMachines(VirtualMachine ... virtualMachines) {
            this.virtualMachines(Arrays.asList(virtualMachines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualMachines(Consumer<VirtualMachine.Builder> ... virtualMachines) {
            this.virtualMachines(Stream.of(virtualMachines).map(c -> (VirtualMachine)((VirtualMachine.Builder)VirtualMachine.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVirtualMachinesResponse build() {
            return new ListVirtualMachinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVirtualMachinesResponse> {
        public Builder nextToken(String var1);

        public Builder virtualMachines(Collection<VirtualMachine> var1);

        public Builder virtualMachines(VirtualMachine ... var1);

        public Builder virtualMachines(Consumer<VirtualMachine.Builder> ... var1);
    }
}

