/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.GatewayType;
import software.amazon.awssdk.services.backupgateway.model.Tag;
import software.amazon.awssdk.services.backupgateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGatewayRequest
extends BackupGatewayRequest
implements ToCopyableBuilder<Builder, CreateGatewayRequest> {
    private static final SdkField<String> ACTIVATION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationKey").getter(CreateGatewayRequest.getter(CreateGatewayRequest::activationKey)).setter(CreateGatewayRequest.setter(Builder::activationKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationKey").build()}).build();
    private static final SdkField<String> GATEWAY_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayDisplayName").getter(CreateGatewayRequest.getter(CreateGatewayRequest::gatewayDisplayName)).setter(CreateGatewayRequest.setter(Builder::gatewayDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayDisplayName").build()}).build();
    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayType").getter(CreateGatewayRequest.getter(CreateGatewayRequest::gatewayTypeAsString)).setter(CreateGatewayRequest.setter(Builder::gatewayType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateGatewayRequest.getter(CreateGatewayRequest::tags)).setter(CreateGatewayRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_KEY_FIELD, GATEWAY_DISPLAY_NAME_FIELD, GATEWAY_TYPE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ActivationKey", ACTIVATION_KEY_FIELD);
            this.put("GatewayDisplayName", GATEWAY_DISPLAY_NAME_FIELD);
            this.put("GatewayType", GATEWAY_TYPE_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String activationKey;
    private final String gatewayDisplayName;
    private final String gatewayType;
    private final List<Tag> tags;

    private CreateGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.activationKey = builder.activationKey;
        this.gatewayDisplayName = builder.gatewayDisplayName;
        this.gatewayType = builder.gatewayType;
        this.tags = builder.tags;
    }

    public final String activationKey() {
        return this.activationKey;
    }

    public final String gatewayDisplayName() {
        return this.gatewayDisplayName;
    }

    public final GatewayType gatewayType() {
        return GatewayType.fromValue(this.gatewayType);
    }

    public final String gatewayTypeAsString() {
        return this.gatewayType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activationKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayRequest)) {
            return false;
        }
        CreateGatewayRequest other = (CreateGatewayRequest)((Object)obj);
        return Objects.equals(this.activationKey(), other.activationKey()) && Objects.equals(this.gatewayDisplayName(), other.gatewayDisplayName()) && Objects.equals(this.gatewayTypeAsString(), other.gatewayTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGatewayRequest").add("ActivationKey", (Object)this.activationKey()).add("GatewayDisplayName", (Object)this.gatewayDisplayName()).add("GatewayType", (Object)this.gatewayTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivationKey": {
                return Optional.ofNullable(clazz.cast(this.activationKey()));
            }
            case "GatewayDisplayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayDisplayName()));
            }
            case "GatewayType": {
                return Optional.ofNullable(clazz.cast(this.gatewayTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayRequest, T> g) {
        return obj -> g.apply((CreateGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupGatewayRequest.BuilderImpl
    implements Builder {
        private String activationKey;
        private String gatewayDisplayName;
        private String gatewayType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayRequest model) {
            super(model);
            this.activationKey(model.activationKey);
            this.gatewayDisplayName(model.gatewayDisplayName);
            this.gatewayType(model.gatewayType);
            this.tags(model.tags);
        }

        public final String getActivationKey() {
            return this.activationKey;
        }

        public final void setActivationKey(String activationKey) {
            this.activationKey = activationKey;
        }

        @Override
        public final Builder activationKey(String activationKey) {
            this.activationKey = activationKey;
            return this;
        }

        public final String getGatewayDisplayName() {
            return this.gatewayDisplayName;
        }

        public final void setGatewayDisplayName(String gatewayDisplayName) {
            this.gatewayDisplayName = gatewayDisplayName;
        }

        @Override
        public final Builder gatewayDisplayName(String gatewayDisplayName) {
            this.gatewayDisplayName = gatewayDisplayName;
            return this;
        }

        public final String getGatewayType() {
            return this.gatewayType;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        @Override
        public final Builder gatewayType(GatewayType gatewayType) {
            this.gatewayType(gatewayType == null ? null : gatewayType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGatewayRequest build() {
            return new CreateGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGatewayRequest> {
        public Builder activationKey(String var1);

        public Builder gatewayDisplayName(String var1);

        public Builder gatewayType(String var1);

        public Builder gatewayType(GatewayType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

