/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupgateway.model.VmwareTag;
import software.amazon.awssdk.services.backupgateway.model.VmwareTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualMachineDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualMachineDetails> {
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostName").getter(VirtualMachineDetails.getter(VirtualMachineDetails::hostName)).setter(VirtualMachineDetails.setter(Builder::hostName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostName").build()}).build();
    private static final SdkField<String> HYPERVISOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HypervisorId").getter(VirtualMachineDetails.getter(VirtualMachineDetails::hypervisorId)).setter(VirtualMachineDetails.setter(Builder::hypervisorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorId").build()}).build();
    private static final SdkField<Instant> LAST_BACKUP_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastBackupDate").getter(VirtualMachineDetails.getter(VirtualMachineDetails::lastBackupDate)).setter(VirtualMachineDetails.setter(Builder::lastBackupDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupDate").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(VirtualMachineDetails.getter(VirtualMachineDetails::name)).setter(VirtualMachineDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(VirtualMachineDetails.getter(VirtualMachineDetails::path)).setter(VirtualMachineDetails.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(VirtualMachineDetails.getter(VirtualMachineDetails::resourceArn)).setter(VirtualMachineDetails.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<List<VmwareTag>> VMWARE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VmwareTags").getter(VirtualMachineDetails.getter(VirtualMachineDetails::vmwareTags)).setter(VirtualMachineDetails.setter(Builder::vmwareTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VmwareTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VmwareTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_NAME_FIELD, HYPERVISOR_ID_FIELD, LAST_BACKUP_DATE_FIELD, NAME_FIELD, PATH_FIELD, RESOURCE_ARN_FIELD, VMWARE_TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hostName;
    private final String hypervisorId;
    private final Instant lastBackupDate;
    private final String name;
    private final String path;
    private final String resourceArn;
    private final List<VmwareTag> vmwareTags;

    private VirtualMachineDetails(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.hypervisorId = builder.hypervisorId;
        this.lastBackupDate = builder.lastBackupDate;
        this.name = builder.name;
        this.path = builder.path;
        this.resourceArn = builder.resourceArn;
        this.vmwareTags = builder.vmwareTags;
    }

    public final String hostName() {
        return this.hostName;
    }

    public final String hypervisorId() {
        return this.hypervisorId;
    }

    public final Instant lastBackupDate() {
        return this.lastBackupDate;
    }

    public final String name() {
        return this.name;
    }

    public final String path() {
        return this.path;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasVmwareTags() {
        return this.vmwareTags != null && !(this.vmwareTags instanceof SdkAutoConstructList);
    }

    public final List<VmwareTag> vmwareTags() {
        return this.vmwareTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastBackupDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVmwareTags() ? this.vmwareTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualMachineDetails)) {
            return false;
        }
        VirtualMachineDetails other = (VirtualMachineDetails)obj;
        return Objects.equals(this.hostName(), other.hostName()) && Objects.equals(this.hypervisorId(), other.hypervisorId()) && Objects.equals(this.lastBackupDate(), other.lastBackupDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasVmwareTags() == other.hasVmwareTags() && Objects.equals(this.vmwareTags(), other.vmwareTags());
    }

    public final String toString() {
        return ToString.builder((String)"VirtualMachineDetails").add("HostName", (Object)this.hostName()).add("HypervisorId", (Object)this.hypervisorId()).add("LastBackupDate", (Object)this.lastBackupDate()).add("Name", (Object)this.name()).add("Path", (Object)this.path()).add("ResourceArn", (Object)this.resourceArn()).add("VmwareTags", this.hasVmwareTags() ? this.vmwareTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostName": {
                return Optional.ofNullable(clazz.cast(this.hostName()));
            }
            case "HypervisorId": {
                return Optional.ofNullable(clazz.cast(this.hypervisorId()));
            }
            case "LastBackupDate": {
                return Optional.ofNullable(clazz.cast(this.lastBackupDate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "VmwareTags": {
                return Optional.ofNullable(clazz.cast(this.vmwareTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualMachineDetails, T> g) {
        return obj -> g.apply((VirtualMachineDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostName;
        private String hypervisorId;
        private Instant lastBackupDate;
        private String name;
        private String path;
        private String resourceArn;
        private List<VmwareTag> vmwareTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualMachineDetails model) {
            this.hostName(model.hostName);
            this.hypervisorId(model.hypervisorId);
            this.lastBackupDate(model.lastBackupDate);
            this.name(model.name);
            this.path(model.path);
            this.resourceArn(model.resourceArn);
            this.vmwareTags(model.vmwareTags);
        }

        public final String getHostName() {
            return this.hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getHypervisorId() {
            return this.hypervisorId;
        }

        public final void setHypervisorId(String hypervisorId) {
            this.hypervisorId = hypervisorId;
        }

        @Override
        public final Builder hypervisorId(String hypervisorId) {
            this.hypervisorId = hypervisorId;
            return this;
        }

        public final Instant getLastBackupDate() {
            return this.lastBackupDate;
        }

        public final void setLastBackupDate(Instant lastBackupDate) {
            this.lastBackupDate = lastBackupDate;
        }

        @Override
        public final Builder lastBackupDate(Instant lastBackupDate) {
            this.lastBackupDate = lastBackupDate;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<VmwareTag.Builder> getVmwareTags() {
            List<VmwareTag.Builder> result = VmwareTagsCopier.copyToBuilder(this.vmwareTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVmwareTags(Collection<VmwareTag.BuilderImpl> vmwareTags) {
            this.vmwareTags = VmwareTagsCopier.copyFromBuilder(vmwareTags);
        }

        @Override
        public final Builder vmwareTags(Collection<VmwareTag> vmwareTags) {
            this.vmwareTags = VmwareTagsCopier.copy(vmwareTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmwareTags(VmwareTag ... vmwareTags) {
            this.vmwareTags(Arrays.asList(vmwareTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmwareTags(Consumer<VmwareTag.Builder> ... vmwareTags) {
            this.vmwareTags(Stream.of(vmwareTags).map(c -> (VmwareTag)((VmwareTag.Builder)VmwareTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VirtualMachineDetails build() {
            return new VirtualMachineDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualMachineDetails> {
        public Builder hostName(String var1);

        public Builder hypervisorId(String var1);

        public Builder lastBackupDate(Instant var1);

        public Builder name(String var1);

        public Builder path(String var1);

        public Builder resourceArn(String var1);

        public Builder vmwareTags(Collection<VmwareTag> var1);

        public Builder vmwareTags(VmwareTag ... var1);

        public Builder vmwareTags(Consumer<VmwareTag.Builder> ... var1);
    }
}

