/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HypervisorState {
    PENDING("PENDING"),
    ONLINE("ONLINE"),
    OFFLINE("OFFLINE"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HypervisorState> VALUE_MAP;
    private final String value;

    private HypervisorState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HypervisorState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HypervisorState> knownValues() {
        EnumSet<HypervisorState> knownValues = EnumSet.allOf(HypervisorState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HypervisorState.class, HypervisorState::toString);
    }
}

