/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.RestoreJobsListMember;

public class ListRestoreJobsByProtectedResourcePublisher
implements SdkPublisher<ListRestoreJobsByProtectedResourceResponse> {
    private final BackupAsyncClient client;
    private final ListRestoreJobsByProtectedResourceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRestoreJobsByProtectedResourcePublisher(BackupAsyncClient client, ListRestoreJobsByProtectedResourceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRestoreJobsByProtectedResourcePublisher(BackupAsyncClient client, ListRestoreJobsByProtectedResourceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRestoreJobsByProtectedResourceResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRestoreJobsByProtectedResourceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RestoreJobsListMember> restoreJobs() {
        return this.flatMapIterable(response -> response.restoreJobs());
    }

    private class ListRestoreJobsByProtectedResourceResponseFetcher
    implements AsyncPageFetcher<ListRestoreJobsByProtectedResourceResponse> {
        private ListRestoreJobsByProtectedResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreJobsByProtectedResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRestoreJobsByProtectedResourceResponse> nextPage(ListRestoreJobsByProtectedResourceResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreJobsByProtectedResourcePublisher.this.client.listRestoreJobsByProtectedResource(ListRestoreJobsByProtectedResourcePublisher.this.firstRequest);
            }
            return ListRestoreJobsByProtectedResourcePublisher.this.client.listRestoreJobsByProtectedResource((ListRestoreJobsByProtectedResourceRequest)((Object)ListRestoreJobsByProtectedResourcePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

