/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ProtectedResource;

public class ListProtectedResourcesByBackupVaultPublisher
implements SdkPublisher<ListProtectedResourcesByBackupVaultResponse> {
    private final BackupAsyncClient client;
    private final ListProtectedResourcesByBackupVaultRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProtectedResourcesByBackupVaultPublisher(BackupAsyncClient client, ListProtectedResourcesByBackupVaultRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProtectedResourcesByBackupVaultPublisher(BackupAsyncClient client, ListProtectedResourcesByBackupVaultRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProtectedResourcesByBackupVaultResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProtectedResourcesByBackupVaultResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProtectedResource> results() {
        return this.flatMapIterable(response -> response.results());
    }

    private class ListProtectedResourcesByBackupVaultResponseFetcher
    implements AsyncPageFetcher<ListProtectedResourcesByBackupVaultResponse> {
        private ListProtectedResourcesByBackupVaultResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectedResourcesByBackupVaultResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProtectedResourcesByBackupVaultResponse> nextPage(ListProtectedResourcesByBackupVaultResponse previousPage) {
            if (previousPage == null) {
                return ListProtectedResourcesByBackupVaultPublisher.this.client.listProtectedResourcesByBackupVault(ListProtectedResourcesByBackupVaultPublisher.this.firstRequest);
            }
            return ListProtectedResourcesByBackupVaultPublisher.this.client.listProtectedResourcesByBackupVault((ListProtectedResourcesByBackupVaultRequest)((Object)ListProtectedResourcesByBackupVaultPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

