/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.ScanJob;
import software.amazon.awssdk.services.backup.model.ScanJobsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScanJobsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListScanJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListScanJobsResponse.getter(ListScanJobsResponse::nextToken)).setter(ListScanJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ScanJob>> SCAN_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScanJobs").getter(ListScanJobsResponse.getter(ListScanJobsResponse::scanJobs)).setter(ListScanJobsResponse.setter(Builder::scanJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCAN_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListScanJobsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ScanJob> scanJobs;

    private ListScanJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scanJobs = builder.scanJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasScanJobs() {
        return this.scanJobs != null && !(this.scanJobs instanceof SdkAutoConstructList);
    }

    public final List<ScanJob> scanJobs() {
        return this.scanJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanJobs() ? this.scanJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScanJobsResponse)) {
            return false;
        }
        ListScanJobsResponse other = (ListScanJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasScanJobs() == other.hasScanJobs() && Objects.equals(this.scanJobs(), other.scanJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListScanJobsResponse").add("NextToken", (Object)this.nextToken()).add("ScanJobs", this.hasScanJobs() ? this.scanJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ScanJobs": {
                return Optional.ofNullable(clazz.cast(this.scanJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ScanJobs", SCAN_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScanJobsResponse, T> g) {
        return obj -> g.apply((ListScanJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScanJob> scanJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScanJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.scanJobs(model.scanJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScanJob.Builder> getScanJobs() {
            List<ScanJob.Builder> result = ScanJobsCopier.copyToBuilder(this.scanJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanJobs(Collection<ScanJob.BuilderImpl> scanJobs) {
            this.scanJobs = ScanJobsCopier.copyFromBuilder(scanJobs);
        }

        @Override
        public final Builder scanJobs(Collection<ScanJob> scanJobs) {
            this.scanJobs = ScanJobsCopier.copy(scanJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanJobs(ScanJob ... scanJobs) {
            this.scanJobs(Arrays.asList(scanJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanJobs(Consumer<ScanJob.Builder> ... scanJobs) {
            this.scanJobs(Stream.of(scanJobs).map(c -> (ScanJob)((ScanJob.Builder)ScanJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListScanJobsResponse build() {
            return new ListScanJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScanJobsResponse> {
        public Builder nextToken(String var1);

        public Builder scanJobs(Collection<ScanJob> var1);

        public Builder scanJobs(ScanJob ... var1);

        public Builder scanJobs(Consumer<ScanJob.Builder> ... var1);
    }
}

