/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.ScanFinding;
import software.amazon.awssdk.services.backup.model.ScanFindingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregatedScanResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregatedScanResult> {
    private static final SdkField<Boolean> FAILED_SCAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FailedScan").getter(AggregatedScanResult.getter(AggregatedScanResult::failedScan)).setter(AggregatedScanResult.setter(Builder::failedScan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedScan").build()}).build();
    private static final SdkField<List<String>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Findings").getter(AggregatedScanResult.getter(AggregatedScanResult::findingsAsStrings)).setter(AggregatedScanResult.setter(Builder::findingsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_COMPUTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastComputed").getter(AggregatedScanResult.getter(AggregatedScanResult::lastComputed)).setter(AggregatedScanResult.setter(Builder::lastComputed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastComputed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_SCAN_FIELD, FINDINGS_FIELD, LAST_COMPUTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregatedScanResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean failedScan;
    private final List<String> findings;
    private final Instant lastComputed;

    private AggregatedScanResult(BuilderImpl builder) {
        this.failedScan = builder.failedScan;
        this.findings = builder.findings;
        this.lastComputed = builder.lastComputed;
    }

    public final Boolean failedScan() {
        return this.failedScan;
    }

    public final List<ScanFinding> findings() {
        return ScanFindingsCopier.copyStringToEnum(this.findings);
    }

    public final boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public final List<String> findingsAsStrings() {
        return this.findings;
    }

    public final Instant lastComputed() {
        return this.lastComputed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failedScan());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindings() ? this.findingsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastComputed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedScanResult)) {
            return false;
        }
        AggregatedScanResult other = (AggregatedScanResult)obj;
        return Objects.equals(this.failedScan(), other.failedScan()) && this.hasFindings() == other.hasFindings() && Objects.equals(this.findingsAsStrings(), other.findingsAsStrings()) && Objects.equals(this.lastComputed(), other.lastComputed());
    }

    public final String toString() {
        return ToString.builder((String)"AggregatedScanResult").add("FailedScan", (Object)this.failedScan()).add("Findings", this.hasFindings() ? this.findingsAsStrings() : null).add("LastComputed", (Object)this.lastComputed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedScan": {
                return Optional.ofNullable(clazz.cast(this.failedScan()));
            }
            case "Findings": {
                return Optional.ofNullable(clazz.cast(this.findingsAsStrings()));
            }
            case "LastComputed": {
                return Optional.ofNullable(clazz.cast(this.lastComputed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FailedScan", FAILED_SCAN_FIELD);
        map.put("Findings", FINDINGS_FIELD);
        map.put("LastComputed", LAST_COMPUTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregatedScanResult, T> g) {
        return obj -> g.apply((AggregatedScanResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean failedScan;
        private List<String> findings = DefaultSdkAutoConstructList.getInstance();
        private Instant lastComputed;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedScanResult model) {
            this.failedScan(model.failedScan);
            this.findingsWithStrings(model.findings);
            this.lastComputed(model.lastComputed);
        }

        public final Boolean getFailedScan() {
            return this.failedScan;
        }

        public final void setFailedScan(Boolean failedScan) {
            this.failedScan = failedScan;
        }

        @Override
        public final Builder failedScan(Boolean failedScan) {
            this.failedScan = failedScan;
            return this;
        }

        public final Collection<String> getFindings() {
            if (this.findings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findings;
        }

        public final void setFindings(Collection<String> findings) {
            this.findings = ScanFindingsCopier.copy(findings);
        }

        @Override
        public final Builder findingsWithStrings(Collection<String> findings) {
            this.findings = ScanFindingsCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsWithStrings(String ... findings) {
            this.findingsWithStrings(Arrays.asList(findings));
            return this;
        }

        @Override
        public final Builder findings(Collection<ScanFinding> findings) {
            this.findings = ScanFindingsCopier.copyEnumToString(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(ScanFinding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        public final Instant getLastComputed() {
            return this.lastComputed;
        }

        public final void setLastComputed(Instant lastComputed) {
            this.lastComputed = lastComputed;
        }

        @Override
        public final Builder lastComputed(Instant lastComputed) {
            this.lastComputed = lastComputed;
            return this;
        }

        public AggregatedScanResult build() {
            return new AggregatedScanResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregatedScanResult> {
        public Builder failedScan(Boolean var1);

        public Builder findingsWithStrings(Collection<String> var1);

        public Builder findingsWithStrings(String ... var1);

        public Builder findings(Collection<ScanFinding> var1);

        public Builder findings(ScanFinding ... var1);

        public Builder lastComputed(Instant var1);
    }
}

