/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateRange> {
    private static final SdkField<Instant> FROM_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FromDate").getter(DateRange.getter(DateRange::fromDate)).setter(DateRange.setter(Builder::fromDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromDate").build()}).build();
    private static final SdkField<Instant> TO_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ToDate").getter(DateRange.getter(DateRange::toDate)).setter(DateRange.setter(Builder::toDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_DATE_FIELD, TO_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DateRange.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant fromDate;
    private final Instant toDate;

    private DateRange(BuilderImpl builder) {
        this.fromDate = builder.fromDate;
        this.toDate = builder.toDate;
    }

    public final Instant fromDate() {
        return this.fromDate;
    }

    public final Instant toDate() {
        return this.toDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.toDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateRange)) {
            return false;
        }
        DateRange other = (DateRange)obj;
        return Objects.equals(this.fromDate(), other.fromDate()) && Objects.equals(this.toDate(), other.toDate());
    }

    public final String toString() {
        return ToString.builder((String)"DateRange").add("FromDate", (Object)this.fromDate()).add("ToDate", (Object)this.toDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromDate": {
                return Optional.ofNullable(clazz.cast(this.fromDate()));
            }
            case "ToDate": {
                return Optional.ofNullable(clazz.cast(this.toDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Instant>> map = new HashMap<String, SdkField<Instant>>();
        map.put("FromDate", FROM_DATE_FIELD);
        map.put("ToDate", TO_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateRange, T> g) {
        return obj -> g.apply((DateRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant fromDate;
        private Instant toDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DateRange model) {
            this.fromDate(model.fromDate);
            this.toDate(model.toDate);
        }

        public final Instant getFromDate() {
            return this.fromDate;
        }

        public final void setFromDate(Instant fromDate) {
            this.fromDate = fromDate;
        }

        @Override
        public final Builder fromDate(Instant fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        public final Instant getToDate() {
            return this.toDate;
        }

        public final void setToDate(Instant toDate) {
            this.toDate = toDate;
        }

        @Override
        public final Builder toDate(Instant toDate) {
            this.toDate = toDate;
            return this;
        }

        public DateRange build() {
            return new DateRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateRange> {
        public Builder fromDate(Instant var1);

        public Builder toDate(Instant var1);
    }
}

