/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.LegalHold;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse;

public class ListLegalHoldsPublisher
implements SdkPublisher<ListLegalHoldsResponse> {
    private final BackupAsyncClient client;
    private final ListLegalHoldsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLegalHoldsPublisher(BackupAsyncClient client, ListLegalHoldsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLegalHoldsPublisher(BackupAsyncClient client, ListLegalHoldsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLegalHoldsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLegalHoldsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LegalHold> legalHolds() {
        return this.flatMapIterable(response -> response.legalHolds());
    }

    private class ListLegalHoldsResponseFetcher
    implements AsyncPageFetcher<ListLegalHoldsResponse> {
        private ListLegalHoldsResponseFetcher() {
        }

        public boolean hasNextPage(ListLegalHoldsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLegalHoldsResponse> nextPage(ListLegalHoldsResponse previousPage) {
            if (previousPage == null) {
                return ListLegalHoldsPublisher.this.client.listLegalHolds(ListLegalHoldsPublisher.this.firstRequest);
            }
            return ListLegalHoldsPublisher.this.client.listLegalHolds((ListLegalHoldsRequest)((Object)ListLegalHoldsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

