/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.RestoreTestingSelectionForUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRestoreTestingSelectionRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, UpdateRestoreTestingSelectionRequest> {
    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreTestingPlanName").getter(UpdateRestoreTestingSelectionRequest.getter(UpdateRestoreTestingSelectionRequest::restoreTestingPlanName)).setter(UpdateRestoreTestingSelectionRequest.setter(Builder::restoreTestingPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RestoreTestingPlanName").build()}).build();
    private static final SdkField<RestoreTestingSelectionForUpdate> RESTORE_TESTING_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestoreTestingSelection").getter(UpdateRestoreTestingSelectionRequest.getter(UpdateRestoreTestingSelectionRequest::restoreTestingSelection)).setter(UpdateRestoreTestingSelectionRequest.setter(Builder::restoreTestingSelection)).constructor(RestoreTestingSelectionForUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelection").build()}).build();
    private static final SdkField<String> RESTORE_TESTING_SELECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreTestingSelectionName").getter(UpdateRestoreTestingSelectionRequest.getter(UpdateRestoreTestingSelectionRequest::restoreTestingSelectionName)).setter(UpdateRestoreTestingSelectionRequest.setter(Builder::restoreTestingSelectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RestoreTestingSelectionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_TESTING_PLAN_NAME_FIELD, RESTORE_TESTING_SELECTION_FIELD, RESTORE_TESTING_SELECTION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRestoreTestingSelectionRequest.memberNameToFieldInitializer();
    private final String restoreTestingPlanName;
    private final RestoreTestingSelectionForUpdate restoreTestingSelection;
    private final String restoreTestingSelectionName;

    private UpdateRestoreTestingSelectionRequest(BuilderImpl builder) {
        super(builder);
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.restoreTestingSelection = builder.restoreTestingSelection;
        this.restoreTestingSelectionName = builder.restoreTestingSelectionName;
    }

    public final String restoreTestingPlanName() {
        return this.restoreTestingPlanName;
    }

    public final RestoreTestingSelectionForUpdate restoreTestingSelection() {
        return this.restoreTestingSelection;
    }

    public final String restoreTestingSelectionName() {
        return this.restoreTestingSelectionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTestingSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTestingSelectionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRestoreTestingSelectionRequest)) {
            return false;
        }
        UpdateRestoreTestingSelectionRequest other = (UpdateRestoreTestingSelectionRequest)((Object)obj);
        return Objects.equals(this.restoreTestingPlanName(), other.restoreTestingPlanName()) && Objects.equals(this.restoreTestingSelection(), other.restoreTestingSelection()) && Objects.equals(this.restoreTestingSelectionName(), other.restoreTestingSelectionName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRestoreTestingSelectionRequest").add("RestoreTestingPlanName", (Object)this.restoreTestingPlanName()).add("RestoreTestingSelection", (Object)this.restoreTestingSelection()).add("RestoreTestingSelectionName", (Object)this.restoreTestingSelectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestoreTestingPlanName": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingPlanName()));
            }
            case "RestoreTestingSelection": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingSelection()));
            }
            case "RestoreTestingSelectionName": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingSelectionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        map.put("RestoreTestingSelection", RESTORE_TESTING_SELECTION_FIELD);
        map.put("RestoreTestingSelectionName", RESTORE_TESTING_SELECTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRestoreTestingSelectionRequest, T> g) {
        return obj -> g.apply((UpdateRestoreTestingSelectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String restoreTestingPlanName;
        private RestoreTestingSelectionForUpdate restoreTestingSelection;
        private String restoreTestingSelectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRestoreTestingSelectionRequest model) {
            super(model);
            this.restoreTestingPlanName(model.restoreTestingPlanName);
            this.restoreTestingSelection(model.restoreTestingSelection);
            this.restoreTestingSelectionName(model.restoreTestingSelectionName);
        }

        public final String getRestoreTestingPlanName() {
            return this.restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final RestoreTestingSelectionForUpdate.Builder getRestoreTestingSelection() {
            return this.restoreTestingSelection != null ? this.restoreTestingSelection.toBuilder() : null;
        }

        public final void setRestoreTestingSelection(RestoreTestingSelectionForUpdate.BuilderImpl restoreTestingSelection) {
            this.restoreTestingSelection = restoreTestingSelection != null ? restoreTestingSelection.build() : null;
        }

        @Override
        public final Builder restoreTestingSelection(RestoreTestingSelectionForUpdate restoreTestingSelection) {
            this.restoreTestingSelection = restoreTestingSelection;
            return this;
        }

        public final String getRestoreTestingSelectionName() {
            return this.restoreTestingSelectionName;
        }

        public final void setRestoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
        }

        @Override
        public final Builder restoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRestoreTestingSelectionRequest build() {
            return new UpdateRestoreTestingSelectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRestoreTestingSelectionRequest> {
        public Builder restoreTestingPlanName(String var1);

        public Builder restoreTestingSelection(RestoreTestingSelectionForUpdate var1);

        default public Builder restoreTestingSelection(Consumer<RestoreTestingSelectionForUpdate.Builder> restoreTestingSelection) {
            return this.restoreTestingSelection((RestoreTestingSelectionForUpdate)((RestoreTestingSelectionForUpdate.Builder)RestoreTestingSelectionForUpdate.builder().applyMutation(restoreTestingSelection)).build());
        }

        public Builder restoreTestingSelectionName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

