/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanResourceType {
    EBS("EBS"),
    EC2("EC2"),
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanResourceType> VALUE_MAP;
    private final String value;

    private ScanResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanResourceType> knownValues() {
        EnumSet<ScanResourceType> knownValues = EnumSet.allOf(ScanResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanResourceType.class, ScanResourceType::toString);
    }
}

