/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.LatestRevokeRequest;
import software.amazon.awssdk.services.backup.model.VaultState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreAccessBackupVaultListMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RestoreAccessBackupVaultListMember> {
    private static final SdkField<String> RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreAccessBackupVaultArn").getter(RestoreAccessBackupVaultListMember.getter(RestoreAccessBackupVaultListMember::restoreAccessBackupVaultArn)).setter(RestoreAccessBackupVaultListMember.setter(Builder::restoreAccessBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreAccessBackupVaultArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(RestoreAccessBackupVaultListMember.getter(RestoreAccessBackupVaultListMember::creationDate)).setter(RestoreAccessBackupVaultListMember.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> APPROVAL_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ApprovalDate").getter(RestoreAccessBackupVaultListMember.getter(RestoreAccessBackupVaultListMember::approvalDate)).setter(RestoreAccessBackupVaultListMember.setter(Builder::approvalDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDate").build()}).build();
    private static final SdkField<String> VAULT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultState").getter(RestoreAccessBackupVaultListMember.getter(RestoreAccessBackupVaultListMember::vaultStateAsString)).setter(RestoreAccessBackupVaultListMember.setter(Builder::vaultState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultState").build()}).build();
    private static final SdkField<LatestRevokeRequest> LATEST_REVOKE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestRevokeRequest").getter(RestoreAccessBackupVaultListMember.getter(RestoreAccessBackupVaultListMember::latestRevokeRequest)).setter(RestoreAccessBackupVaultListMember.setter(Builder::latestRevokeRequest)).constructor(LatestRevokeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRevokeRequest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD, CREATION_DATE_FIELD, APPROVAL_DATE_FIELD, VAULT_STATE_FIELD, LATEST_REVOKE_REQUEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreAccessBackupVaultListMember.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String restoreAccessBackupVaultArn;
    private final Instant creationDate;
    private final Instant approvalDate;
    private final String vaultState;
    private final LatestRevokeRequest latestRevokeRequest;

    private RestoreAccessBackupVaultListMember(BuilderImpl builder) {
        this.restoreAccessBackupVaultArn = builder.restoreAccessBackupVaultArn;
        this.creationDate = builder.creationDate;
        this.approvalDate = builder.approvalDate;
        this.vaultState = builder.vaultState;
        this.latestRevokeRequest = builder.latestRevokeRequest;
    }

    public final String restoreAccessBackupVaultArn() {
        return this.restoreAccessBackupVaultArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant approvalDate() {
        return this.approvalDate;
    }

    public final VaultState vaultState() {
        return VaultState.fromValue(this.vaultState);
    }

    public final String vaultStateAsString() {
        return this.vaultState;
    }

    public final LatestRevokeRequest latestRevokeRequest() {
        return this.latestRevokeRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreAccessBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRevokeRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreAccessBackupVaultListMember)) {
            return false;
        }
        RestoreAccessBackupVaultListMember other = (RestoreAccessBackupVaultListMember)obj;
        return Objects.equals(this.restoreAccessBackupVaultArn(), other.restoreAccessBackupVaultArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.approvalDate(), other.approvalDate()) && Objects.equals(this.vaultStateAsString(), other.vaultStateAsString()) && Objects.equals(this.latestRevokeRequest(), other.latestRevokeRequest());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreAccessBackupVaultListMember").add("RestoreAccessBackupVaultArn", (Object)this.restoreAccessBackupVaultArn()).add("CreationDate", (Object)this.creationDate()).add("ApprovalDate", (Object)this.approvalDate()).add("VaultState", (Object)this.vaultStateAsString()).add("LatestRevokeRequest", (Object)this.latestRevokeRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestoreAccessBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.restoreAccessBackupVaultArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "ApprovalDate": {
                return Optional.ofNullable(clazz.cast(this.approvalDate()));
            }
            case "VaultState": {
                return Optional.ofNullable(clazz.cast(this.vaultStateAsString()));
            }
            case "LatestRevokeRequest": {
                return Optional.ofNullable(clazz.cast(this.latestRevokeRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RestoreAccessBackupVaultArn", RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("ApprovalDate", APPROVAL_DATE_FIELD);
        map.put("VaultState", VAULT_STATE_FIELD);
        map.put("LatestRevokeRequest", LATEST_REVOKE_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreAccessBackupVaultListMember, T> g) {
        return obj -> g.apply((RestoreAccessBackupVaultListMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String restoreAccessBackupVaultArn;
        private Instant creationDate;
        private Instant approvalDate;
        private String vaultState;
        private LatestRevokeRequest latestRevokeRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreAccessBackupVaultListMember model) {
            this.restoreAccessBackupVaultArn(model.restoreAccessBackupVaultArn);
            this.creationDate(model.creationDate);
            this.approvalDate(model.approvalDate);
            this.vaultState(model.vaultState);
            this.latestRevokeRequest(model.latestRevokeRequest);
        }

        public final String getRestoreAccessBackupVaultArn() {
            return this.restoreAccessBackupVaultArn;
        }

        public final void setRestoreAccessBackupVaultArn(String restoreAccessBackupVaultArn) {
            this.restoreAccessBackupVaultArn = restoreAccessBackupVaultArn;
        }

        @Override
        public final Builder restoreAccessBackupVaultArn(String restoreAccessBackupVaultArn) {
            this.restoreAccessBackupVaultArn = restoreAccessBackupVaultArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getApprovalDate() {
            return this.approvalDate;
        }

        public final void setApprovalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
        }

        @Override
        public final Builder approvalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public final String getVaultState() {
            return this.vaultState;
        }

        public final void setVaultState(String vaultState) {
            this.vaultState = vaultState;
        }

        @Override
        public final Builder vaultState(String vaultState) {
            this.vaultState = vaultState;
            return this;
        }

        @Override
        public final Builder vaultState(VaultState vaultState) {
            this.vaultState(vaultState == null ? null : vaultState.toString());
            return this;
        }

        public final LatestRevokeRequest.Builder getLatestRevokeRequest() {
            return this.latestRevokeRequest != null ? this.latestRevokeRequest.toBuilder() : null;
        }

        public final void setLatestRevokeRequest(LatestRevokeRequest.BuilderImpl latestRevokeRequest) {
            this.latestRevokeRequest = latestRevokeRequest != null ? latestRevokeRequest.build() : null;
        }

        @Override
        public final Builder latestRevokeRequest(LatestRevokeRequest latestRevokeRequest) {
            this.latestRevokeRequest = latestRevokeRequest;
            return this;
        }

        public RestoreAccessBackupVaultListMember build() {
            return new RestoreAccessBackupVaultListMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RestoreAccessBackupVaultListMember> {
        public Builder restoreAccessBackupVaultArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder approvalDate(Instant var1);

        public Builder vaultState(String var1);

        public Builder vaultState(VaultState var1);

        public Builder latestRevokeRequest(LatestRevokeRequest var1);

        default public Builder latestRevokeRequest(Consumer<LatestRevokeRequest.Builder> latestRevokeRequest) {
            return this.latestRevokeRequest((LatestRevokeRequest)((LatestRevokeRequest.Builder)LatestRevokeRequest.builder().applyMutation(latestRevokeRequest)).build());
        }
    }
}

