/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.IndexedRecoveryPoint;
import software.amazon.awssdk.services.backup.model.ListIndexedRecoveryPointsRequest;
import software.amazon.awssdk.services.backup.model.ListIndexedRecoveryPointsResponse;

public class ListIndexedRecoveryPointsPublisher
implements SdkPublisher<ListIndexedRecoveryPointsResponse> {
    private final BackupAsyncClient client;
    private final ListIndexedRecoveryPointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIndexedRecoveryPointsPublisher(BackupAsyncClient client, ListIndexedRecoveryPointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIndexedRecoveryPointsPublisher(BackupAsyncClient client, ListIndexedRecoveryPointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIndexedRecoveryPointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIndexedRecoveryPointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IndexedRecoveryPoint> indexedRecoveryPoints() {
        return this.flatMapIterable(response -> response.indexedRecoveryPoints());
    }

    private class ListIndexedRecoveryPointsResponseFetcher
    implements AsyncPageFetcher<ListIndexedRecoveryPointsResponse> {
        private ListIndexedRecoveryPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListIndexedRecoveryPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIndexedRecoveryPointsResponse> nextPage(ListIndexedRecoveryPointsResponse previousPage) {
            if (previousPage == null) {
                return ListIndexedRecoveryPointsPublisher.this.client.listIndexedRecoveryPoints(ListIndexedRecoveryPointsPublisher.this.firstRequest);
            }
            return ListIndexedRecoveryPointsPublisher.this.client.listIndexedRecoveryPoints((ListIndexedRecoveryPointsRequest)((Object)ListIndexedRecoveryPointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

