/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanFinding {
    MALWARE("MALWARE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanFinding> VALUE_MAP;
    private final String value;

    private ScanFinding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanFinding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanFinding> knownValues() {
        EnumSet<ScanFinding> knownValues = EnumSet.allOf(ScanFinding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanFinding.class, ScanFinding::toString);
    }
}

