/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.IndexedRecoveryPoint;
import software.amazon.awssdk.services.backup.model.ListIndexedRecoveryPointsRequest;
import software.amazon.awssdk.services.backup.model.ListIndexedRecoveryPointsResponse;

public class ListIndexedRecoveryPointsIterable
implements SdkIterable<ListIndexedRecoveryPointsResponse> {
    private final BackupClient client;
    private final ListIndexedRecoveryPointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIndexedRecoveryPointsIterable(BackupClient client, ListIndexedRecoveryPointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIndexedRecoveryPointsResponseFetcher();
    }

    public Iterator<ListIndexedRecoveryPointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IndexedRecoveryPoint> indexedRecoveryPoints() {
        Function<ListIndexedRecoveryPointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.indexedRecoveryPoints() != null) {
                return response.indexedRecoveryPoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIndexedRecoveryPointsResponseFetcher
    implements SyncPageFetcher<ListIndexedRecoveryPointsResponse> {
        private ListIndexedRecoveryPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListIndexedRecoveryPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIndexedRecoveryPointsResponse nextPage(ListIndexedRecoveryPointsResponse previousPage) {
            if (previousPage == null) {
                return ListIndexedRecoveryPointsIterable.this.client.listIndexedRecoveryPoints(ListIndexedRecoveryPointsIterable.this.firstRequest);
            }
            return ListIndexedRecoveryPointsIterable.this.client.listIndexedRecoveryPoints((ListIndexedRecoveryPointsRequest)((Object)ListIndexedRecoveryPointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

