/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreAccessBackupVaultsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreAccessBackupVaultsResponse;
import software.amazon.awssdk.services.backup.model.RestoreAccessBackupVaultListMember;

public class ListRestoreAccessBackupVaultsIterable
implements SdkIterable<ListRestoreAccessBackupVaultsResponse> {
    private final BackupClient client;
    private final ListRestoreAccessBackupVaultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRestoreAccessBackupVaultsIterable(BackupClient client, ListRestoreAccessBackupVaultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRestoreAccessBackupVaultsResponseFetcher();
    }

    public Iterator<ListRestoreAccessBackupVaultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults() {
        Function<ListRestoreAccessBackupVaultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.restoreAccessBackupVaults() != null) {
                return response.restoreAccessBackupVaults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRestoreAccessBackupVaultsResponseFetcher
    implements SyncPageFetcher<ListRestoreAccessBackupVaultsResponse> {
        private ListRestoreAccessBackupVaultsResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreAccessBackupVaultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRestoreAccessBackupVaultsResponse nextPage(ListRestoreAccessBackupVaultsResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreAccessBackupVaultsIterable.this.client.listRestoreAccessBackupVaults(ListRestoreAccessBackupVaultsIterable.this.firstRequest);
            }
            return ListRestoreAccessBackupVaultsIterable.this.client.listRestoreAccessBackupVaults((ListRestoreAccessBackupVaultsRequest)((Object)ListRestoreAccessBackupVaultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

