/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A framework consists of one or more controls. Each control has its own control scope. The control scope can include
 * one or more resource types, a combination of a tag key and value, or a combination of one resource type and one
 * resource ID. If no scope is specified, evaluations for the rule are triggered when any resource in your recording
 * group changes in configuration.
 * </p>
 * <note>
 * <p>
 * To set a control scope that includes all of a particular resource, leave the <code>ControlScope</code> empty or do
 * not pass it when calling <code>CreateFramework</code>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlScope implements SdkPojo, Serializable, ToCopyableBuilder<ControlScope.Builder, ControlScope> {
    private static final SdkField<List<String>> COMPLIANCE_RESOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ComplianceResourceIds")
            .getter(getter(ControlScope::complianceResourceIds))
            .setter(setter(Builder::complianceResourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> COMPLIANCE_RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ComplianceResourceTypes")
            .getter(getter(ControlScope::complianceResourceTypes))
            .setter(setter(Builder::complianceResourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(ControlScope::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_RESOURCE_IDS_FIELD,
            COMPLIANCE_RESOURCE_TYPES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> complianceResourceIds;

    private final List<String> complianceResourceTypes;

    private final Map<String, String> tags;

    private ControlScope(BuilderImpl builder) {
        this.complianceResourceIds = builder.complianceResourceIds;
        this.complianceResourceTypes = builder.complianceResourceTypes;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComplianceResourceIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComplianceResourceIds() {
        return complianceResourceIds != null && !(complianceResourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the only Amazon Web Services resource that you want your control scope to contain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComplianceResourceIds} method.
     * </p>
     * 
     * @return The ID of the only Amazon Web Services resource that you want your control scope to contain.
     */
    public final List<String> complianceResourceIds() {
        return complianceResourceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComplianceResourceTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComplianceResourceTypes() {
        return complianceResourceTypes != null && !(complianceResourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes whether the control scope includes one or more types of resources, such as <code>EFS</code> or
     * <code>RDS</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComplianceResourceTypes} method.
     * </p>
     * 
     * @return Describes whether the control scope includes one or more types of resources, such as <code>EFS</code> or
     *         <code>RDS</code>.
     */
    public final List<String> complianceResourceTypes() {
        return complianceResourceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tag key-value pair applied to those Amazon Web Services resources that you want to trigger an evaluation for
     * a rule. A maximum of one key-value pair can be provided. The tag value is optional, but it cannot be an empty
     * string if you are creating or editing a framework from the console (though the value can be an empty string when
     * included in a CloudFormation template).
     * </p>
     * <p>
     * The structure to assign a tag is: <code>[{"Key":"string","Value":"string"}]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag key-value pair applied to those Amazon Web Services resources that you want to trigger an
     *         evaluation for a rule. A maximum of one key-value pair can be provided. The tag value is optional, but it
     *         cannot be an empty string if you are creating or editing a framework from the console (though the value
     *         can be an empty string when included in a CloudFormation template).</p>
     *         <p>
     *         The structure to assign a tag is: <code>[{"Key":"string","Value":"string"}]</code>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasComplianceResourceIds() ? complianceResourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasComplianceResourceTypes() ? complianceResourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlScope)) {
            return false;
        }
        ControlScope other = (ControlScope) obj;
        return hasComplianceResourceIds() == other.hasComplianceResourceIds()
                && Objects.equals(complianceResourceIds(), other.complianceResourceIds())
                && hasComplianceResourceTypes() == other.hasComplianceResourceTypes()
                && Objects.equals(complianceResourceTypes(), other.complianceResourceTypes()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlScope")
                .add("ComplianceResourceIds", hasComplianceResourceIds() ? complianceResourceIds() : null)
                .add("ComplianceResourceTypes", hasComplianceResourceTypes() ? complianceResourceTypes() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceResourceIds":
            return Optional.ofNullable(clazz.cast(complianceResourceIds()));
        case "ComplianceResourceTypes":
            return Optional.ofNullable(clazz.cast(complianceResourceTypes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComplianceResourceIds", COMPLIANCE_RESOURCE_IDS_FIELD);
        map.put("ComplianceResourceTypes", COMPLIANCE_RESOURCE_TYPES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlScope, T> g) {
        return obj -> g.apply((ControlScope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlScope> {
        /**
         * <p>
         * The ID of the only Amazon Web Services resource that you want your control scope to contain.
         * </p>
         * 
         * @param complianceResourceIds
         *        The ID of the only Amazon Web Services resource that you want your control scope to contain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceIds(Collection<String> complianceResourceIds);

        /**
         * <p>
         * The ID of the only Amazon Web Services resource that you want your control scope to contain.
         * </p>
         * 
         * @param complianceResourceIds
         *        The ID of the only Amazon Web Services resource that you want your control scope to contain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceIds(String... complianceResourceIds);

        /**
         * <p>
         * Describes whether the control scope includes one or more types of resources, such as <code>EFS</code> or
         * <code>RDS</code>.
         * </p>
         * 
         * @param complianceResourceTypes
         *        Describes whether the control scope includes one or more types of resources, such as <code>EFS</code>
         *        or <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceTypes(Collection<String> complianceResourceTypes);

        /**
         * <p>
         * Describes whether the control scope includes one or more types of resources, such as <code>EFS</code> or
         * <code>RDS</code>.
         * </p>
         * 
         * @param complianceResourceTypes
         *        Describes whether the control scope includes one or more types of resources, such as <code>EFS</code>
         *        or <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceTypes(String... complianceResourceTypes);

        /**
         * <p>
         * The tag key-value pair applied to those Amazon Web Services resources that you want to trigger an evaluation
         * for a rule. A maximum of one key-value pair can be provided. The tag value is optional, but it cannot be an
         * empty string if you are creating or editing a framework from the console (though the value can be an empty
         * string when included in a CloudFormation template).
         * </p>
         * <p>
         * The structure to assign a tag is: <code>[{"Key":"string","Value":"string"}]</code>.
         * </p>
         * 
         * @param tags
         *        The tag key-value pair applied to those Amazon Web Services resources that you want to trigger an
         *        evaluation for a rule. A maximum of one key-value pair can be provided. The tag value is optional, but
         *        it cannot be an empty string if you are creating or editing a framework from the console (though the
         *        value can be an empty string when included in a CloudFormation template).</p>
         *        <p>
         *        The structure to assign a tag is: <code>[{"Key":"string","Value":"string"}]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private List<String> complianceResourceIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> complianceResourceTypes = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ControlScope model) {
            complianceResourceIds(model.complianceResourceIds);
            complianceResourceTypes(model.complianceResourceTypes);
            tags(model.tags);
        }

        public final Collection<String> getComplianceResourceIds() {
            if (complianceResourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return complianceResourceIds;
        }

        public final void setComplianceResourceIds(Collection<String> complianceResourceIds) {
            this.complianceResourceIds = ComplianceResourceIdListCopier.copy(complianceResourceIds);
        }

        @Override
        public final Builder complianceResourceIds(Collection<String> complianceResourceIds) {
            this.complianceResourceIds = ComplianceResourceIdListCopier.copy(complianceResourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceResourceIds(String... complianceResourceIds) {
            complianceResourceIds(Arrays.asList(complianceResourceIds));
            return this;
        }

        public final Collection<String> getComplianceResourceTypes() {
            if (complianceResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return complianceResourceTypes;
        }

        public final void setComplianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ResourceTypeListCopier.copy(complianceResourceTypes);
        }

        @Override
        public final Builder complianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ResourceTypeListCopier.copy(complianceResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceResourceTypes(String... complianceResourceTypes) {
            complianceResourceTypes(Arrays.asList(complianceResourceTypes));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = _stringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = _stringMapCopier.copy(tags);
            return this;
        }

        @Override
        public ControlScope build() {
            return new ControlScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
