/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MalwareScanner {
    GUARDDUTY("GUARDDUTY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MalwareScanner> VALUE_MAP;
    private final String value;

    private MalwareScanner(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MalwareScanner fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MalwareScanner> knownValues() {
        EnumSet<MalwareScanner> knownValues = EnumSet.allOf(MalwareScanner.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MalwareScanner.class, MalwareScanner::toString);
    }
}

