/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is a recovery point which is a child (nested) recovery point of a parent (composite) recovery point. These
 * recovery points can be disassociated from their parent (composite) recovery point, in which case they will no longer
 * be a member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryPointMember implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryPointMember.Builder, RecoveryPointMember> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(RecoveryPointMember::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(RecoveryPointMember::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(RecoveryPointMember::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(RecoveryPointMember::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD,
            RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, BACKUP_VAULT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String recoveryPointArn;

    private final String resourceArn;

    private final String resourceType;

    private final String backupVaultName;

    private RecoveryPointMember(BuilderImpl builder) {
        this.recoveryPointArn = builder.recoveryPointArn;
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.backupVaultName = builder.backupVaultName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the parent (composite) recovery point.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the parent (composite) recovery point.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies a saved resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies a saved resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The Amazon Web Services resource type that is saved as a recovery point.
     * </p>
     * 
     * @return The Amazon Web Services resource type that is saved as a recovery point.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The name of the backup vault (the logical container in which backups are stored).
     * </p>
     * 
     * @return The name of the backup vault (the logical container in which backups are stored).
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointMember)) {
            return false;
        }
        RecoveryPointMember other = (RecoveryPointMember) obj;
        return Objects.equals(recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(backupVaultName(), other.backupVaultName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryPointMember").add("RecoveryPointArn", recoveryPointArn())
                .add("ResourceArn", resourceArn()).add("ResourceType", resourceType()).add("BackupVaultName", backupVaultName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointMember, T> g) {
        return obj -> g.apply((RecoveryPointMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryPointMember> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the parent (composite) recovery point.
         * </p>
         * 
         * @param recoveryPointArn
         *        The Amazon Resource Name (ARN) of the parent (composite) recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies a saved resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) that uniquely identifies a saved resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The Amazon Web Services resource type that is saved as a recovery point.
         * </p>
         * 
         * @param resourceType
         *        The Amazon Web Services resource type that is saved as a recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The name of the backup vault (the logical container in which backups are stored).
         * </p>
         * 
         * @param backupVaultName
         *        The name of the backup vault (the logical container in which backups are stored).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);
    }

    static final class BuilderImpl implements Builder {
        private String recoveryPointArn;

        private String resourceArn;

        private String resourceType;

        private String backupVaultName;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointMember model) {
            recoveryPointArn(model.recoveryPointArn);
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            backupVaultName(model.backupVaultName);
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        @Override
        public RecoveryPointMember build() {
            return new RecoveryPointMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
