/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conditions that you define for resources in your restore testing plan using tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedResourceConditions implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedResourceConditions.Builder, ProtectedResourceConditions> {
    private static final SdkField<List<KeyValue>> STRING_EQUALS_FIELD = SdkField
            .<List<KeyValue>> builder(MarshallingType.LIST)
            .memberName("StringEquals")
            .getter(getter(ProtectedResourceConditions::stringEquals))
            .setter(setter(Builder::stringEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringEquals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KeyValue>> STRING_NOT_EQUALS_FIELD = SdkField
            .<List<KeyValue>> builder(MarshallingType.LIST)
            .memberName("StringNotEquals")
            .getter(getter(ProtectedResourceConditions::stringNotEquals))
            .setter(setter(Builder::stringNotEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringNotEquals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_EQUALS_FIELD,
            STRING_NOT_EQUALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<KeyValue> stringEquals;

    private final List<KeyValue> stringNotEquals;

    private ProtectedResourceConditions(BuilderImpl builder) {
        this.stringEquals = builder.stringEquals;
        this.stringNotEquals = builder.stringNotEquals;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringEquals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringEquals() {
        return stringEquals != null && !(stringEquals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the values of your tagged resources for only those resources that you tagged with the same value. Also
     * called "exact matching."
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringEquals} method.
     * </p>
     * 
     * @return Filters the values of your tagged resources for only those resources that you tagged with the same value.
     *         Also called "exact matching."
     */
    public final List<KeyValue> stringEquals() {
        return stringEquals;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringNotEquals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringNotEquals() {
        return stringNotEquals != null && !(stringNotEquals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the values of your tagged resources for only those resources that you tagged that do not have the same
     * value. Also called "negated matching."
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringNotEquals} method.
     * </p>
     * 
     * @return Filters the values of your tagged resources for only those resources that you tagged that do not have the
     *         same value. Also called "negated matching."
     */
    public final List<KeyValue> stringNotEquals() {
        return stringNotEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStringEquals() ? stringEquals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStringNotEquals() ? stringNotEquals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedResourceConditions)) {
            return false;
        }
        ProtectedResourceConditions other = (ProtectedResourceConditions) obj;
        return hasStringEquals() == other.hasStringEquals() && Objects.equals(stringEquals(), other.stringEquals())
                && hasStringNotEquals() == other.hasStringNotEquals()
                && Objects.equals(stringNotEquals(), other.stringNotEquals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedResourceConditions").add("StringEquals", hasStringEquals() ? stringEquals() : null)
                .add("StringNotEquals", hasStringNotEquals() ? stringNotEquals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringEquals":
            return Optional.ofNullable(clazz.cast(stringEquals()));
        case "StringNotEquals":
            return Optional.ofNullable(clazz.cast(stringNotEquals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringEquals", STRING_EQUALS_FIELD);
        map.put("StringNotEquals", STRING_NOT_EQUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedResourceConditions, T> g) {
        return obj -> g.apply((ProtectedResourceConditions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedResourceConditions> {
        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged with the same value.
         * Also called "exact matching."
         * </p>
         * 
         * @param stringEquals
         *        Filters the values of your tagged resources for only those resources that you tagged with the same
         *        value. Also called "exact matching."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringEquals(Collection<KeyValue> stringEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged with the same value.
         * Also called "exact matching."
         * </p>
         * 
         * @param stringEquals
         *        Filters the values of your tagged resources for only those resources that you tagged with the same
         *        value. Also called "exact matching."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringEquals(KeyValue... stringEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged with the same value.
         * Also called "exact matching."
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.KeyValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.backup.model.KeyValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.KeyValue.Builder#build()} is called immediately and its
         * result is passed to {@link #stringEquals(List<KeyValue>)}.
         * 
         * @param stringEquals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.KeyValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringEquals(java.util.Collection<KeyValue>)
         */
        Builder stringEquals(Consumer<KeyValue.Builder>... stringEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged that do not have the
         * same value. Also called "negated matching."
         * </p>
         * 
         * @param stringNotEquals
         *        Filters the values of your tagged resources for only those resources that you tagged that do not have
         *        the same value. Also called "negated matching."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringNotEquals(Collection<KeyValue> stringNotEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged that do not have the
         * same value. Also called "negated matching."
         * </p>
         * 
         * @param stringNotEquals
         *        Filters the values of your tagged resources for only those resources that you tagged that do not have
         *        the same value. Also called "negated matching."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringNotEquals(KeyValue... stringNotEquals);

        /**
         * <p>
         * Filters the values of your tagged resources for only those resources that you tagged that do not have the
         * same value. Also called "negated matching."
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.KeyValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.backup.model.KeyValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.KeyValue.Builder#build()} is called immediately and its
         * result is passed to {@link #stringNotEquals(List<KeyValue>)}.
         * 
         * @param stringNotEquals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.KeyValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringNotEquals(java.util.Collection<KeyValue>)
         */
        Builder stringNotEquals(Consumer<KeyValue.Builder>... stringNotEquals);
    }

    static final class BuilderImpl implements Builder {
        private List<KeyValue> stringEquals = DefaultSdkAutoConstructList.getInstance();

        private List<KeyValue> stringNotEquals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedResourceConditions model) {
            stringEquals(model.stringEquals);
            stringNotEquals(model.stringNotEquals);
        }

        public final List<KeyValue.Builder> getStringEquals() {
            List<KeyValue.Builder> result = KeyValueListCopier.copyToBuilder(this.stringEquals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringEquals(Collection<KeyValue.BuilderImpl> stringEquals) {
            this.stringEquals = KeyValueListCopier.copyFromBuilder(stringEquals);
        }

        @Override
        public final Builder stringEquals(Collection<KeyValue> stringEquals) {
            this.stringEquals = KeyValueListCopier.copy(stringEquals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringEquals(KeyValue... stringEquals) {
            stringEquals(Arrays.asList(stringEquals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringEquals(Consumer<KeyValue.Builder>... stringEquals) {
            stringEquals(Stream.of(stringEquals).map(c -> KeyValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<KeyValue.Builder> getStringNotEquals() {
            List<KeyValue.Builder> result = KeyValueListCopier.copyToBuilder(this.stringNotEquals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringNotEquals(Collection<KeyValue.BuilderImpl> stringNotEquals) {
            this.stringNotEquals = KeyValueListCopier.copyFromBuilder(stringNotEquals);
        }

        @Override
        public final Builder stringNotEquals(Collection<KeyValue> stringNotEquals) {
            this.stringNotEquals = KeyValueListCopier.copy(stringNotEquals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringNotEquals(KeyValue... stringNotEquals) {
            stringNotEquals(Arrays.asList(stringNotEquals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringNotEquals(Consumer<KeyValue.Builder>... stringNotEquals) {
            stringNotEquals(Stream.of(stringNotEquals).map(c -> KeyValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProtectedResourceConditions build() {
            return new ProtectedResourceConditions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
