/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRestoreJobSummariesResponse extends BackupResponse implements
        ToCopyableBuilder<ListRestoreJobSummariesResponse.Builder, ListRestoreJobSummariesResponse> {
    private static final SdkField<List<RestoreJobSummary>> RESTORE_JOB_SUMMARIES_FIELD = SdkField
            .<List<RestoreJobSummary>> builder(MarshallingType.LIST)
            .memberName("RestoreJobSummaries")
            .getter(getter(ListRestoreJobSummariesResponse::restoreJobSummaries))
            .setter(setter(Builder::restoreJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RestoreJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RestoreJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregationPeriod").getter(getter(ListRestoreJobSummariesResponse::aggregationPeriod))
            .setter(setter(Builder::aggregationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationPeriod").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRestoreJobSummariesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_JOB_SUMMARIES_FIELD,
            AGGREGATION_PERIOD_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RestoreJobSummary> restoreJobSummaries;

    private final String aggregationPeriod;

    private final String nextToken;

    private ListRestoreJobSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.restoreJobSummaries = builder.restoreJobSummaries;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestoreJobSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRestoreJobSummaries() {
        return restoreJobSummaries != null && !(restoreJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This return contains a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestoreJobSummaries} method.
     * </p>
     * 
     * @return This return contains a summary that contains Region, Account, State, ResourceType, MessageCategory,
     *         StartTime, EndTime, and Count of included jobs.
     */
    public final List<RestoreJobSummary> restoreJobSummaries() {
        return restoreJobSummaries;
    }

    /**
     * <p>
     * The period for the returned results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONE_DAY</code> - The daily job count for the prior 14 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SEVEN_DAYS</code> - The aggregated job count for the prior 7 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOURTEEN_DAYS</code> - The aggregated job count for prior 14 days.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The period for the returned results.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONE_DAY</code> - The daily job count for the prior 14 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SEVEN_DAYS</code> - The aggregated job count for the prior 7 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOURTEEN_DAYS</code> - The aggregated job count for prior 14 days.
     *         </p>
     *         </li>
     */
    public final String aggregationPeriod() {
        return aggregationPeriod;
    }

    /**
     * <p>
     * The next item following a partial list of returned resources. For example, if a request is made to return
     * <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned resources. For example, if a request is made to return
     *         <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in
     *         your list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRestoreJobSummaries() ? restoreJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(aggregationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreJobSummariesResponse)) {
            return false;
        }
        ListRestoreJobSummariesResponse other = (ListRestoreJobSummariesResponse) obj;
        return hasRestoreJobSummaries() == other.hasRestoreJobSummaries()
                && Objects.equals(restoreJobSummaries(), other.restoreJobSummaries())
                && Objects.equals(aggregationPeriod(), other.aggregationPeriod())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRestoreJobSummariesResponse")
                .add("RestoreJobSummaries", hasRestoreJobSummaries() ? restoreJobSummaries() : null)
                .add("AggregationPeriod", aggregationPeriod()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreJobSummaries":
            return Optional.ofNullable(clazz.cast(restoreJobSummaries()));
        case "AggregationPeriod":
            return Optional.ofNullable(clazz.cast(aggregationPeriod()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestoreJobSummaries", RESTORE_JOB_SUMMARIES_FIELD);
        map.put("AggregationPeriod", AGGREGATION_PERIOD_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreJobSummariesResponse, T> g) {
        return obj -> g.apply((ListRestoreJobSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRestoreJobSummariesResponse> {
        /**
         * <p>
         * This return contains a summary that contains Region, Account, State, ResourceType, MessageCategory,
         * StartTime, EndTime, and Count of included jobs.
         * </p>
         * 
         * @param restoreJobSummaries
         *        This return contains a summary that contains Region, Account, State, ResourceType, MessageCategory,
         *        StartTime, EndTime, and Count of included jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreJobSummaries(Collection<RestoreJobSummary> restoreJobSummaries);

        /**
         * <p>
         * This return contains a summary that contains Region, Account, State, ResourceType, MessageCategory,
         * StartTime, EndTime, and Count of included jobs.
         * </p>
         * 
         * @param restoreJobSummaries
         *        This return contains a summary that contains Region, Account, State, ResourceType, MessageCategory,
         *        StartTime, EndTime, and Count of included jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreJobSummaries(RestoreJobSummary... restoreJobSummaries);

        /**
         * <p>
         * This return contains a summary that contains Region, Account, State, ResourceType, MessageCategory,
         * StartTime, EndTime, and Count of included jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.RestoreJobSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backup.model.RestoreJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.RestoreJobSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #restoreJobSummaries(List<RestoreJobSummary>)}.
         * 
         * @param restoreJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.RestoreJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreJobSummaries(java.util.Collection<RestoreJobSummary>)
         */
        Builder restoreJobSummaries(Consumer<RestoreJobSummary.Builder>... restoreJobSummaries);

        /**
         * <p>
         * The period for the returned results.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONE_DAY</code> - The daily job count for the prior 14 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SEVEN_DAYS</code> - The aggregated job count for the prior 7 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOURTEEN_DAYS</code> - The aggregated job count for prior 14 days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aggregationPeriod
         *        The period for the returned results.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONE_DAY</code> - The daily job count for the prior 14 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SEVEN_DAYS</code> - The aggregated job count for the prior 7 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOURTEEN_DAYS</code> - The aggregated job count for prior 14 days.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationPeriod(String aggregationPeriod);

        /**
         * <p>
         * The next item following a partial list of returned resources. For example, if a request is made to return
         * <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your
         * list starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned resources. For example, if a request is made to
         *        return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more
         *        items in your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private List<RestoreJobSummary> restoreJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String aggregationPeriod;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreJobSummariesResponse model) {
            super(model);
            restoreJobSummaries(model.restoreJobSummaries);
            aggregationPeriod(model.aggregationPeriod);
            nextToken(model.nextToken);
        }

        public final List<RestoreJobSummary.Builder> getRestoreJobSummaries() {
            List<RestoreJobSummary.Builder> result = RestoreJobSummaryListCopier.copyToBuilder(this.restoreJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestoreJobSummaries(Collection<RestoreJobSummary.BuilderImpl> restoreJobSummaries) {
            this.restoreJobSummaries = RestoreJobSummaryListCopier.copyFromBuilder(restoreJobSummaries);
        }

        @Override
        public final Builder restoreJobSummaries(Collection<RestoreJobSummary> restoreJobSummaries) {
            this.restoreJobSummaries = RestoreJobSummaryListCopier.copy(restoreJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreJobSummaries(RestoreJobSummary... restoreJobSummaries) {
            restoreJobSummaries(Arrays.asList(restoreJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreJobSummaries(Consumer<RestoreJobSummary.Builder>... restoreJobSummaries) {
            restoreJobSummaries(Stream.of(restoreJobSummaries).map(c -> RestoreJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAggregationPeriod() {
            return aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRestoreJobSummariesResponse build() {
            return new ListRestoreJobSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
