/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about all of the controls of a framework. Each framework must contain at least one
 * control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrameworkControl implements SdkPojo, Serializable,
        ToCopyableBuilder<FrameworkControl.Builder, FrameworkControl> {
    private static final SdkField<String> CONTROL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlName").getter(getter(FrameworkControl::controlName)).setter(setter(Builder::controlName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlName").build()).build();

    private static final SdkField<List<ControlInputParameter>> CONTROL_INPUT_PARAMETERS_FIELD = SdkField
            .<List<ControlInputParameter>> builder(MarshallingType.LIST)
            .memberName("ControlInputParameters")
            .getter(getter(FrameworkControl::controlInputParameters))
            .setter(setter(Builder::controlInputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlInputParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlInputParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlInputParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ControlScope> CONTROL_SCOPE_FIELD = SdkField.<ControlScope> builder(MarshallingType.SDK_POJO)
            .memberName("ControlScope").getter(getter(FrameworkControl::controlScope)).setter(setter(Builder::controlScope))
            .constructor(ControlScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_NAME_FIELD,
            CONTROL_INPUT_PARAMETERS_FIELD, CONTROL_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String controlName;

    private final List<ControlInputParameter> controlInputParameters;

    private final ControlScope controlScope;

    private FrameworkControl(BuilderImpl builder) {
        this.controlName = builder.controlName;
        this.controlInputParameters = builder.controlInputParameters;
        this.controlScope = builder.controlScope;
    }

    /**
     * <p>
     * The name of a control. This name is between 1 and 256 characters.
     * </p>
     * 
     * @return The name of a control. This name is between 1 and 256 characters.
     */
    public final String controlName() {
        return controlName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlInputParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasControlInputParameters() {
        return controlInputParameters != null && !(controlInputParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name/value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlInputParameters} method.
     * </p>
     * 
     * @return The name/value pairs.
     */
    public final List<ControlInputParameter> controlInputParameters() {
        return controlInputParameters;
    }

    /**
     * <p>
     * The scope of a control. The control scope defines what the control will evaluate. Three examples of control
     * scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html">
     * <code>ControlScope</code>.</a>
     * </p>
     * 
     * @return The scope of a control. The control scope defines what the control will evaluate. Three examples of
     *         control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup
     *         plans.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html">
     *         <code>ControlScope</code>.</a>
     */
    public final ControlScope controlScope() {
        return controlScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(controlName());
        hashCode = 31 * hashCode + Objects.hashCode(hasControlInputParameters() ? controlInputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(controlScope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameworkControl)) {
            return false;
        }
        FrameworkControl other = (FrameworkControl) obj;
        return Objects.equals(controlName(), other.controlName())
                && hasControlInputParameters() == other.hasControlInputParameters()
                && Objects.equals(controlInputParameters(), other.controlInputParameters())
                && Objects.equals(controlScope(), other.controlScope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrameworkControl").add("ControlName", controlName())
                .add("ControlInputParameters", hasControlInputParameters() ? controlInputParameters() : null)
                .add("ControlScope", controlScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlName":
            return Optional.ofNullable(clazz.cast(controlName()));
        case "ControlInputParameters":
            return Optional.ofNullable(clazz.cast(controlInputParameters()));
        case "ControlScope":
            return Optional.ofNullable(clazz.cast(controlScope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ControlName", CONTROL_NAME_FIELD);
        map.put("ControlInputParameters", CONTROL_INPUT_PARAMETERS_FIELD);
        map.put("ControlScope", CONTROL_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FrameworkControl, T> g) {
        return obj -> g.apply((FrameworkControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrameworkControl> {
        /**
         * <p>
         * The name of a control. This name is between 1 and 256 characters.
         * </p>
         * 
         * @param controlName
         *        The name of a control. This name is between 1 and 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlName(String controlName);

        /**
         * <p>
         * The name/value pairs.
         * </p>
         * 
         * @param controlInputParameters
         *        The name/value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlInputParameters(Collection<ControlInputParameter> controlInputParameters);

        /**
         * <p>
         * The name/value pairs.
         * </p>
         * 
         * @param controlInputParameters
         *        The name/value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlInputParameters(ControlInputParameter... controlInputParameters);

        /**
         * <p>
         * The name/value pairs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.ControlInputParameter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.backup.model.ControlInputParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.ControlInputParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #controlInputParameters(List<ControlInputParameter>)}.
         * 
         * @param controlInputParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.ControlInputParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlInputParameters(java.util.Collection<ControlInputParameter>)
         */
        Builder controlInputParameters(Consumer<ControlInputParameter.Builder>... controlInputParameters);

        /**
         * <p>
         * The scope of a control. The control scope defines what the control will evaluate. Three examples of control
         * scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html">
         * <code>ControlScope</code>.</a>
         * </p>
         * 
         * @param controlScope
         *        The scope of a control. The control scope defines what the control will evaluate. Three examples of
         *        control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup
         *        plans.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html">
         *        <code>ControlScope</code>.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlScope(ControlScope controlScope);

        /**
         * <p>
         * The scope of a control. The control scope defines what the control will evaluate. Three examples of control
         * scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html">
         * <code>ControlScope</code>.</a>
         * </p>
         * This is a convenience method that creates an instance of the {@link ControlScope.Builder} avoiding the need
         * to create one manually via {@link ControlScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ControlScope.Builder#build()} is called immediately and its
         * result is passed to {@link #controlScope(ControlScope)}.
         * 
         * @param controlScope
         *        a consumer that will call methods on {@link ControlScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlScope(ControlScope)
         */
        default Builder controlScope(Consumer<ControlScope.Builder> controlScope) {
            return controlScope(ControlScope.builder().applyMutation(controlScope).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String controlName;

        private List<ControlInputParameter> controlInputParameters = DefaultSdkAutoConstructList.getInstance();

        private ControlScope controlScope;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameworkControl model) {
            controlName(model.controlName);
            controlInputParameters(model.controlInputParameters);
            controlScope(model.controlScope);
        }

        public final String getControlName() {
            return controlName;
        }

        public final void setControlName(String controlName) {
            this.controlName = controlName;
        }

        @Override
        public final Builder controlName(String controlName) {
            this.controlName = controlName;
            return this;
        }

        public final List<ControlInputParameter.Builder> getControlInputParameters() {
            List<ControlInputParameter.Builder> result = ControlInputParametersCopier.copyToBuilder(this.controlInputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlInputParameters(Collection<ControlInputParameter.BuilderImpl> controlInputParameters) {
            this.controlInputParameters = ControlInputParametersCopier.copyFromBuilder(controlInputParameters);
        }

        @Override
        public final Builder controlInputParameters(Collection<ControlInputParameter> controlInputParameters) {
            this.controlInputParameters = ControlInputParametersCopier.copy(controlInputParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlInputParameters(ControlInputParameter... controlInputParameters) {
            controlInputParameters(Arrays.asList(controlInputParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlInputParameters(Consumer<ControlInputParameter.Builder>... controlInputParameters) {
            controlInputParameters(Stream.of(controlInputParameters)
                    .map(c -> ControlInputParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ControlScope.Builder getControlScope() {
            return controlScope != null ? controlScope.toBuilder() : null;
        }

        public final void setControlScope(ControlScope.BuilderImpl controlScope) {
            this.controlScope = controlScope != null ? controlScope.build() : null;
        }

        @Override
        public final Builder controlScope(ControlScope controlScope) {
            this.controlScope = controlScope;
            return this;
        }

        @Override
        public FrameworkControl build() {
            return new FrameworkControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
